/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.util;

import com.github.houbb.csv.annotation.Csv;
import com.github.houbb.csv.annotation.CsvEntry;
import com.github.houbb.csv.constant.CsvOperateType;
import com.github.houbb.heaven.reflect.model.FieldBean;
import com.github.houbb.heaven.support.sort.ISort;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.lang.reflect.ReflectFieldUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class CsvFieldUtil {
    private static final Map<String, List<FieldBean>> CACHE = new ConcurrentHashMap<String, List<FieldBean>>();

    private CsvFieldUtil() {
    }

    public static List<FieldBean> getSortedFields(Class tClass, ISort sort, CsvOperateType type) {
        String cacheKey = CsvFieldUtil.buildCacheKey(tClass, type);
        if (CACHE.containsKey(cacheKey)) {
            return CACHE.get(cacheKey);
        }
        List<FieldBean> resultList = Guavas.newArrayList();
        List allFields = ClassUtil.getAllFieldList((Class)tClass);
        if (CollectionUtil.isEmpty((Collection)allFields)) {
            resultList = Collections.emptyList();
        }
        List sortedFields = sort.sort(allFields);
        for (Field field : sortedFields) {
            Csv csv = null;
            if (field.isAnnotationPresent(Csv.class)) {
                csv = field.getAnnotation(Csv.class);
                if (CsvOperateType.READ.equals((Object)type) && !csv.readRequire() || CsvOperateType.WRITE.equals((Object)type) && !csv.writeRequire()) continue;
            }
            FieldBean fieldBean = new FieldBean();
            fieldBean.field(field).name(field.getName()).annotation((Annotation)csv);
            resultList.add(fieldBean);
        }
        CACHE.put(cacheKey, resultList);
        return resultList;
    }

    private static String buildCacheKey(Class tClass, CsvOperateType type) {
        return tClass.getName() + "_" + type.name();
    }

    public static Map<Integer, FieldBean> getReadMapping(Class tClass, ISort sort) {
        List<FieldBean> sortedFields = CsvFieldUtil.getSortedFields(tClass, sort, CsvOperateType.READ);
        return MapUtil.toIndexMap(sortedFields);
    }

    public static boolean isEntryAble(Field field) {
        return ReflectFieldUtil.isAnnotationPresent((Field)field, CsvEntry.class) && ClassTypeUtil.isJavaBean(field.getType());
    }
}

