/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.bs;

import com.github.houbb.csv.api.ICsv;
import com.github.houbb.csv.support.context.DefaultReadContext;
import com.github.houbb.csv.support.csv.DefaultCsv;
import com.github.houbb.csv.support.csv.DefaultStringListCsv;
import com.github.houbb.csv.support.reader.ICsvReader;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.support.sort.ISort;
import com.github.houbb.heaven.support.sort.impl.NoSort;
import com.github.houbb.heaven.util.common.ArgUtil;
import java.util.List;

public final class CsvReadBs {
    private ICsvReader reader;
    private int startIndex = 1;
    private int endIndex = Integer.MAX_VALUE;
    private boolean escape = false;
    private char quoteChar = (char)34;
    @Deprecated
    private ISort sort = (ISort)Instances.singleton(NoSort.class);
    private final ICsv csv = (ICsv)Instances.singleton(DefaultCsv.class);

    private CsvReadBs() {
    }

    public static CsvReadBs newInstance() {
        return new CsvReadBs();
    }

    public CsvReadBs reader(ICsvReader reader) {
        ArgUtil.notNull((Object)reader, (String)"reader");
        this.reader = reader;
        return this;
    }

    public CsvReadBs startIndex(int startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    public CsvReadBs endIndex(int endIndex) {
        this.endIndex = endIndex;
        return this;
    }

    public CsvReadBs escape(boolean escape) {
        this.escape = escape;
        return this;
    }

    public CsvReadBs quoteChar(char quoteChar) {
        this.quoteChar = quoteChar;
        return this;
    }

    public <T> List<T> read(Class<T> tClass) {
        DefaultReadContext context = new DefaultReadContext();
        context.reader(this.reader).startIndex(this.startIndex).endIndex(this.endIndex).sort(this.sort).readClass(tClass).escape(this.escape).quoteChar(this.quoteChar);
        return this.csv.read(context);
    }

    public List<List<String>> readStringList() {
        DefaultReadContext context = new DefaultReadContext();
        context.reader(this.reader).startIndex(this.startIndex).endIndex(this.endIndex).sort(this.sort).escape(this.escape).quoteChar(this.quoteChar);
        DefaultStringListCsv csv = new DefaultStringListCsv();
        return csv.read(context);
    }
}

