/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.bs;

import com.github.houbb.csv.api.ICsv;
import com.github.houbb.csv.support.context.DefaultWriteContext;
import com.github.houbb.csv.support.csv.DefaultCsv;
import com.github.houbb.csv.support.csv.DefaultStringListCsv;
import com.github.houbb.csv.support.writer.ICsvWriter;
import com.github.houbb.csv.support.writer.impl.CsvWriterNone;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.support.sort.ISort;
import com.github.houbb.heaven.support.sort.impl.NoSort;
import com.github.houbb.heaven.util.common.ArgUtil;
import java.util.List;

public final class CsvWriteBs {
    private boolean writeHead = true;
    private boolean writeBom = true;
    private ICsvWriter writer = (ICsvWriter)Instances.singleton(CsvWriterNone.class);
    @Deprecated
    private ISort sort = (ISort)Instances.singleton(NoSort.class);
    private boolean escape = false;
    private ICsv csv = (ICsv)Instances.singleton(DefaultCsv.class);
    private char quoteChar = (char)34;

    private CsvWriteBs() {
    }

    public static CsvWriteBs newInstance() {
        return new CsvWriteBs();
    }

    public CsvWriteBs writeHead(boolean writeHead) {
        this.writeHead = writeHead;
        return this;
    }

    public CsvWriteBs writeBom(boolean writeBom) {
        this.writeBom = writeBom;
        return this;
    }

    public CsvWriteBs sort(ISort sort) {
        ArgUtil.notNull((Object)sort, (String)"sort");
        this.sort = sort;
        return this;
    }

    public CsvWriteBs escape(boolean escape) {
        this.escape = escape;
        return this;
    }

    public CsvWriteBs writer(ICsvWriter writer) {
        ArgUtil.notNull((Object)writer, (String)"writer");
        this.writer = writer;
        return this;
    }

    public CsvWriteBs quoteChar(char quoteChar) {
        this.quoteChar = quoteChar;
        return this;
    }

    public <T> List<String> write(List<T> list) {
        DefaultWriteContext<T> context = new DefaultWriteContext<T>();
        context.list(list).writeHead(this.writeHead).writeBom(this.writeBom).sort(this.sort).escape(this.escape).writer(this.writer).quoteChar(this.quoteChar);
        return this.csv.write(context);
    }

    public void writeStringList(List<List<String>> list) {
        DefaultWriteContext<List<String>> context = new DefaultWriteContext<List<String>>();
        context.list(list).writeHead(this.writeHead).writeBom(this.writeBom).sort(this.sort).escape(this.escape).writer(this.writer).quoteChar(this.quoteChar);
        DefaultStringListCsv csv = new DefaultStringListCsv();
        csv.write(context);
    }
}

