/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.support.convert.read;

import com.github.houbb.csv.api.IReadConverter;
import com.github.houbb.csv.support.context.SingleReadContext;
import com.github.houbb.csv.support.convert.read.collection.ArrayReadConverter;
import com.github.houbb.csv.support.convert.read.collection.CollectionReadConverter;
import com.github.houbb.csv.support.convert.read.collection.MapReadConverter;
import com.github.houbb.csv.support.convert.read.entry.EntryReadConverter;
import com.github.houbb.csv.support.convert.read.type.ITypeConverter;
import com.github.houbb.csv.support.convert.read.type.impl.BooleanReadConverter;
import com.github.houbb.csv.support.convert.read.type.impl.ByteReadConverter;
import com.github.houbb.csv.support.convert.read.type.impl.CharacterReadConverter;
import com.github.houbb.csv.support.convert.read.type.impl.DoubleReadConverter;
import com.github.houbb.csv.support.convert.read.type.impl.FloatReadConverter;
import com.github.houbb.csv.support.convert.read.type.impl.IntegerReadConverter;
import com.github.houbb.csv.support.convert.read.type.impl.LongReadConverter;
import com.github.houbb.csv.support.convert.read.type.impl.ShortReadConverter;
import com.github.houbb.csv.support.convert.read.type.impl.StringReadConverter;
import com.github.houbb.csv.util.CsvFieldUtil;
import com.github.houbb.csv.util.CsvInnerUtil;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.instance.impl.InstanceFactory;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.support.sort.ISort;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;
import com.github.houbb.heaven.util.lang.reflect.PrimitiveUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

@ThreadSafe
public class CommonReadConverter
implements IReadConverter<Object> {
    private static final Map<Class, ITypeConverter> CONVERTER_MAP = new HashMap<Class, ITypeConverter>();

    @Override
    public Object convert(SingleReadContext context) {
        String value = context.value();
        Field field = context.field();
        String split = context.split();
        ISort sort = context.sort();
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        Class<?> refType = field.getType();
        if (ClassTypeUtil.isArray(refType)) {
            return ((ArrayReadConverter)Instances.singleton(ArrayReadConverter.class)).convert(context);
        }
        if (ClassTypeUtil.isMap(refType)) {
            return ((MapReadConverter)Instances.singleton(MapReadConverter.class)).convert(context);
        }
        if (ClassTypeUtil.isCollection(refType)) {
            return ((CollectionReadConverter)Instances.singleton(CollectionReadConverter.class)).convert(context);
        }
        if (CsvFieldUtil.isEntryAble(field)) {
            String nextSplit = CsvInnerUtil.getNextSplit(split);
            SingleReadContext singleReadContext = new SingleReadContext();
            singleReadContext.sort(sort).value(value).split(nextSplit).classType(refType).field(field).escape(context.escape());
            return ((EntryReadConverter)Instances.singleton(EntryReadConverter.class)).convert(singleReadContext);
        }
        boolean escape = context.escape();
        return this.convert(value, refType, escape);
    }

    public Object convert(String value, Class type, boolean escape) {
        ITypeConverter readConverter;
        if (StringUtil.isEmpty((String)value) || ObjectUtil.isNull((Object)type)) {
            return null;
        }
        Class actualType = type;
        if (actualType.isPrimitive()) {
            actualType = PrimitiveUtil.getReferenceType((Class)actualType);
        }
        if (ObjectUtil.isNotNull((Object)(readConverter = CONVERTER_MAP.get(actualType)))) {
            if (escape) {
                value = CsvInnerUtil.replaceAllEscape(value);
            }
            return readConverter.convert(value, actualType);
        }
        return null;
    }

    static {
        CONVERTER_MAP.put(String.class, (ITypeConverter)InstanceFactory.getInstance().singleton(StringReadConverter.class));
        CONVERTER_MAP.put(Byte.class, (ITypeConverter)InstanceFactory.getInstance().singleton(ByteReadConverter.class));
        CONVERTER_MAP.put(Boolean.class, (ITypeConverter)InstanceFactory.getInstance().singleton(BooleanReadConverter.class));
        CONVERTER_MAP.put(Short.class, (ITypeConverter)InstanceFactory.getInstance().singleton(ShortReadConverter.class));
        CONVERTER_MAP.put(Integer.class, (ITypeConverter)InstanceFactory.getInstance().singleton(IntegerReadConverter.class));
        CONVERTER_MAP.put(Long.class, (ITypeConverter)InstanceFactory.getInstance().singleton(LongReadConverter.class));
        CONVERTER_MAP.put(Float.class, (ITypeConverter)InstanceFactory.getInstance().singleton(FloatReadConverter.class));
        CONVERTER_MAP.put(Double.class, (ITypeConverter)InstanceFactory.getInstance().singleton(DoubleReadConverter.class));
        CONVERTER_MAP.put(Character.class, (ITypeConverter)InstanceFactory.getInstance().singleton(CharacterReadConverter.class));
    }
}

