/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.support.convert.read.collection;

import com.github.houbb.csv.api.IReadConverter;
import com.github.houbb.csv.support.context.SingleReadContext;
import com.github.houbb.csv.support.convert.read.CommonReadConverter;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.lang.reflect.ReflectFieldUtil;
import java.lang.reflect.Field;
import java.util.Collection;

public class CollectionReadConverter
implements IReadConverter<Collection> {
    @Override
    public Collection convert(SingleReadContext context) {
        String value = context.value();
        Field field = context.field();
        String[] entrys = value.split("\\|");
        Collection collection = this.getCollection(field.getType(), entrys.length);
        Class componentType = ReflectFieldUtil.getComponentType((Field)field);
        CommonReadConverter readConverter = (CommonReadConverter)Instances.singleton(CommonReadConverter.class);
        for (String string : entrys) {
            Object object = readConverter.convert(string, componentType, context.escape());
            collection.add(object);
        }
        return collection;
    }

    private Collection getCollection(Class fieldType, int size) {
        if (ClassTypeUtil.isList((Class)fieldType) && ClassTypeUtil.isAbstractOrInterface((Class)fieldType)) {
            return Guavas.newArrayList((int)size);
        }
        if (ClassTypeUtil.isSet((Class)fieldType) && ClassTypeUtil.isAbstractOrInterface((Class)fieldType)) {
            return Guavas.newHashSet((int)size);
        }
        if (ClassTypeUtil.isAbstractOrInterface((Class)fieldType)) {
            throw new UnsupportedOperationException("Only support set or list field component type!");
        }
        return (Collection)ClassUtil.newInstance((Class)fieldType);
    }
}

