/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.support.convert.read.collection;

import com.github.houbb.csv.api.IReadConverter;
import com.github.houbb.csv.support.context.SingleReadContext;
import com.github.houbb.csv.support.convert.read.CommonReadConverter;
import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;
import com.github.houbb.heaven.util.lang.reflect.ReflectFieldUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;

public class MapReadConverter
implements IReadConverter<Map> {
    @Override
    public Map convert(SingleReadContext context) {
        String value = context.value();
        Field field = context.field();
        Object[] entryStrings = value.split("\\|");
        if (ArrayUtil.isEmpty((Object[])entryStrings)) {
            return Collections.emptyMap();
        }
        Map map = this.getMap(field, entryStrings.length);
        Class keyType = ReflectFieldUtil.getComponentType((Field)field, (int)0);
        Class valueType = ReflectFieldUtil.getComponentType((Field)field, (int)1);
        CommonReadConverter readConverter = (CommonReadConverter)Instances.singleton(CommonReadConverter.class);
        for (Object entryStr : entryStrings) {
            Object[] kvs;
            if (StringUtil.isEmpty((String)entryStr) || ArrayUtil.isEmpty((Object[])(kvs = ((String)entryStr).split("=")))) continue;
            Object keyObj = readConverter.convert((String)kvs[0], keyType, context.escape());
            Object valueObj = readConverter.convert((String)kvs[1], valueType, context.escape());
            map.put(keyObj, valueObj);
        }
        return map;
    }

    private Map getMap(Field field, int size) {
        Class<?> fieldType = field.getType();
        if (ClassTypeUtil.isAbstractOrInterface(fieldType)) {
            return Guavas.newHashMap((int)size);
        }
        try {
            return (Map)fieldType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CommonRuntimeException((Throwable)e);
        }
    }
}

