/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.support.convert.read.entry;

import com.github.houbb.csv.annotation.Csv;
import com.github.houbb.csv.api.IReadConverter;
import com.github.houbb.csv.support.context.SingleReadContext;
import com.github.houbb.csv.support.convert.mapping.ReadMappingConverter;
import com.github.houbb.csv.support.convert.read.CommonReadConverter;
import com.github.houbb.csv.util.CsvFieldUtil;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.reflect.model.FieldBean;
import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.support.instance.impl.InstanceFactory;
import com.github.houbb.heaven.support.sort.ISort;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class EntryReadConverter<T>
implements IReadConverter<T> {
    @Override
    public T convert(SingleReadContext context) {
        Class clazz = context.classType();
        String csvLine = context.value();
        ISort sort = context.sort();
        String split = context.split();
        Map<Integer, FieldBean> readMapping = CsvFieldUtil.getReadMapping(clazz, sort);
        Object instance = ClassUtil.newInstance((Class)clazz);
        List<String> stringList = this.splitCsvLine(csvLine, split);
        int minSize = this.getMinSize(stringList.size(), readMapping.size());
        try {
            for (int i = 0; i < minSize; ++i) {
                String value = stringList.get(i);
                Field field = readMapping.get(i).field();
                Object object = this.convertReadValue(value, field, context);
                field.set(instance, object);
            }
            return (T)instance;
        }
        catch (IllegalAccessException e) {
            throw new CommonRuntimeException((Throwable)e);
        }
    }

    private List<String> splitCsvLine(String line, String split) {
        String fitLine = line;
        if (fitLine.endsWith(split)) {
            fitLine = fitLine + " ";
        }
        String[] strings = fitLine.split(split);
        return CollectionUtil.arrayToList((String[])strings);
    }

    private Object convertReadValue(String csvContent, Field field, SingleReadContext oldContext) {
        try {
            SingleReadContext context = SingleReadContext.newInstance().value(csvContent).field(field).split(oldContext.split()).sort(oldContext.sort()).escape(oldContext.escape());
            if (field.isAnnotationPresent(Csv.class)) {
                Csv csv = field.getAnnotation(Csv.class);
                context.csv(csv);
                Class<? extends IReadConverter> readConverterClass = csv.readConverter();
                String readMapping = csv.readMapping();
                if (StringUtil.isNotEmpty((String)readMapping) && field.getType().equals(String.class)) {
                    readConverterClass = ReadMappingConverter.class;
                }
                return readConverterClass.newInstance().convert(context);
            }
            return ((CommonReadConverter)InstanceFactory.getInstance().singleton(CommonReadConverter.class)).convert(context);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CommonRuntimeException((Throwable)e);
        }
    }

    private int getMinSize(int sizeOne, int sizeTwo) {
        return sizeOne > sizeTwo ? sizeTwo : sizeOne;
    }
}

