/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.support.convert.write;

import com.github.houbb.csv.api.IWriteConverter;
import com.github.houbb.csv.support.context.SingleWriteContext;
import com.github.houbb.csv.support.convert.write.StringWriteConverter;
import com.github.houbb.csv.support.convert.write.collection.ArrayWriteConverter;
import com.github.houbb.csv.support.convert.write.collection.CollectionWriteConverter;
import com.github.houbb.csv.support.convert.write.collection.MapWriteConverter;
import com.github.houbb.csv.support.convert.write.entry.EntryWriteConverter;
import com.github.houbb.csv.util.CsvFieldUtil;
import com.github.houbb.csv.util.CsvInnerUtil;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;

public class CommonWriteConverter
implements IWriteConverter {
    @Override
    public String convert(SingleWriteContext context) {
        Object value = context.value();
        if (ObjectUtil.isNull((Object)value)) {
            return "";
        }
        Class<?> type = value.getClass();
        if (ClassTypeUtil.isArray(type)) {
            return ((ArrayWriteConverter)Instances.singleton(ArrayWriteConverter.class)).convert(context);
        }
        if (ClassTypeUtil.isMap(type)) {
            return ((MapWriteConverter)Instances.singleton(MapWriteConverter.class)).convert(context);
        }
        if (ClassTypeUtil.isCollection(type)) {
            return ((CollectionWriteConverter)Instances.singleton(CollectionWriteConverter.class)).convert(context);
        }
        if (CsvFieldUtil.isEntryAble(context.field())) {
            String split = CsvInnerUtil.getNextSplit(context.split());
            SingleWriteContext singleWriteContext = SingleWriteContext.newInstance().sort(context.sort()).element(context.value()).split(split).escape(context.escape());
            return ((EntryWriteConverter)Instances.singleton(EntryWriteConverter.class)).convert(singleWriteContext);
        }
        return ((StringWriteConverter)Instances.singleton(StringWriteConverter.class)).convert(context);
    }
}

