/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.support.convert.write.collection;

import com.github.houbb.csv.api.IWriteConverter;
import com.github.houbb.csv.support.context.SingleWriteContext;
import com.github.houbb.csv.support.convert.write.StringWriteConverter;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.support.tuple.impl.Pair;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.util.Collections;
import java.util.List;

@ThreadSafe
public class ArrayWriteConverter
implements IWriteConverter {
    @Override
    public String convert(SingleWriteContext context) {
        List<String> stringList = this.buildStringList(context);
        return StringUtil.join(stringList, (String)"|");
    }

    private List<String> buildStringList(SingleWriteContext context) {
        Object value = context.value();
        if (ObjectUtil.isNull((Object)value)) {
            return Collections.emptyList();
        }
        Object[] arrays = (Object[])value;
        List stringList = Guavas.newArrayList((int)arrays.length);
        boolean escape = context.escape();
        for (Object object : arrays) {
            Pair pair = Pair.of((Object)object, (Object)escape);
            String string = ((StringWriteConverter)Instances.singleton(StringWriteConverter.class)).handle((Pair<Object, Boolean>)pair);
            stringList.add(string);
        }
        return stringList;
    }
}

