/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.support.convert.write.entry;

import com.github.houbb.csv.annotation.Csv;
import com.github.houbb.csv.api.IWriteConverter;
import com.github.houbb.csv.constant.CsvOperateType;
import com.github.houbb.csv.support.context.SingleWriteContext;
import com.github.houbb.csv.support.convert.mapping.WriteMappingConverter;
import com.github.houbb.csv.support.convert.write.CommonWriteConverter;
import com.github.houbb.csv.util.CsvFieldUtil;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.reflect.model.FieldBean;
import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.heaven.util.util.Optional;
import java.util.Collection;
import java.util.List;

@ThreadSafe
public class EntryWriteConverter
implements IWriteConverter {
    @Override
    public String convert(SingleWriteContext context) {
        Object value = context.element();
        if (ObjectUtil.isNull((Object)value)) {
            return "";
        }
        Class<?> clazz = value.getClass();
        List<FieldBean> fieldBeanList = CsvFieldUtil.getSortedFields(clazz, context.sort(), CsvOperateType.WRITE);
        if (CollectionUtil.isEmpty(fieldBeanList)) {
            return "";
        }
        return this.buildWriteLine(context, value, fieldBeanList);
    }

    private String buildWriteLine(SingleWriteContext context, Object t, List<FieldBean> fieldBeans) {
        if (ObjectUtil.isNull((Object)t)) {
            return "";
        }
        List stringList = Guavas.newArrayList((int)fieldBeans.size());
        IWriteConverter converter = (IWriteConverter)Instances.singleton(CommonWriteConverter.class);
        try {
            for (FieldBean bean : fieldBeans) {
                Object object = bean.field().get(t);
                SingleWriteContext entryContext = SingleWriteContext.newInstance().value(object).field(bean.field()).element(t).sort(context.sort()).split(",").escape(context.escape());
                Optional csvOptional = bean.annotationOptByType(Csv.class);
                if (csvOptional.isPresent()) {
                    Csv csv = (Csv)csvOptional.get();
                    entryContext.csv(csv);
                    converter = csv.writeConverter().newInstance();
                    if (StringUtil.isNotEmpty((String)csv.writeMapping()) && object instanceof String) {
                        converter = new WriteMappingConverter();
                    }
                }
                String string = converter.convert(entryContext);
                stringList.add(string);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CommonRuntimeException((Throwable)e);
        }
        return CollectionUtil.join((Collection)stringList, (String)context.split());
    }
}

