/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.support.csv;

import com.github.houbb.csv.annotation.Csv;
import com.github.houbb.csv.api.ICsv;
import com.github.houbb.csv.api.IReadContext;
import com.github.houbb.csv.api.IWriteContext;
import com.github.houbb.csv.constant.CsvOperateType;
import com.github.houbb.csv.support.context.SingleReadContext;
import com.github.houbb.csv.support.context.SingleWriteContext;
import com.github.houbb.csv.support.convert.read.entry.EntryReadConverter;
import com.github.houbb.csv.support.convert.write.entry.EntryWriteConverter;
import com.github.houbb.csv.support.writer.ICsvWriter;
import com.github.houbb.csv.support.writer.impl.CsvWriterContext;
import com.github.houbb.csv.util.CsvFieldUtil;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.reflect.model.FieldBean;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.heaven.util.util.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class DefaultCsv<T>
implements ICsv<T> {
    @Override
    public List<String> write(IWriteContext<T> context) {
        List<T> writeList = context.list();
        if (CollectionUtil.isEmpty(writeList)) {
            return Collections.emptyList();
        }
        Optional firstOpt = CollectionUtil.firstNotNullElem(writeList);
        if (firstOpt.isNotPresent()) {
            return Collections.emptyList();
        }
        Object elem = firstOpt.get();
        List<FieldBean> fieldBeanList = CsvFieldUtil.getSortedFields(elem.getClass(), context.sort(), CsvOperateType.WRITE);
        if (CollectionUtil.isEmpty(fieldBeanList)) {
            return Collections.emptyList();
        }
        int size = context.list().size();
        List list = Guavas.newArrayList((int)size);
        EntryWriteConverter entryWriteConverter = new EntryWriteConverter();
        SingleWriteContext singleWriteContext = SingleWriteContext.newInstance().sort(context.sort()).escape(context.escape()).split(",");
        for (T t : writeList) {
            singleWriteContext.element(t);
            String writeLine = entryWriteConverter.convert(singleWriteContext);
            if (StringUtil.isEmpty((String)writeLine)) continue;
            list.add(writeLine);
        }
        ICsvWriter csvWriter = context.writer();
        CsvWriterContext csvWriterContext = CsvWriterContext.newInstance().writeBom(context.writeBom()).writeHead(context.writeHead()).list(list);
        boolean needWriteHead = context.writeHead();
        if (needWriteHead) {
            String headLine = this.buildWriteHead(fieldBeanList);
            csvWriterContext.head(headLine);
        }
        csvWriter.write(csvWriterContext);
        return list;
    }

    private String buildWriteHead(List<FieldBean> fieldBeanList) {
        List headList = Guavas.newArrayList((int)fieldBeanList.size());
        for (FieldBean bean : fieldBeanList) {
            String label;
            String name = bean.name();
            Optional csvOptional = bean.annotationOptByType(Csv.class);
            if (csvOptional.isPresent() && StringUtil.isNotEmpty((String)(label = ((Csv)csvOptional.get()).label()))) {
                name = label;
            }
            headList.add(name);
        }
        return StringUtil.join((Collection)headList, (String)",");
    }

    @Override
    public List<T> read(IReadContext<T> context) {
        Map<Integer, FieldBean> readMapping = CsvFieldUtil.getReadMapping(context.readClass(), context.sort());
        if (MapUtil.isEmpty(readMapping)) {
            return Collections.emptyList();
        }
        List<String> allLines = context.reader().read();
        List readableLines = CollectionUtil.subList(allLines, (int)context.startIndex(), (int)context.endIndex());
        if (CollectionUtil.isEmpty((Collection)readableLines)) {
            return Collections.emptyList();
        }
        List list = Guavas.newArrayList((int)readableLines.size());
        Class<T> readClass = context.readClass();
        EntryReadConverter readConverter = new EntryReadConverter();
        SingleReadContext singleReadContext = new SingleReadContext();
        singleReadContext.classType(readClass).sort(context.sort()).split(",").escape(context.escape());
        for (String line : readableLines) {
            if (StringUtil.isEmpty((String)line)) continue;
            singleReadContext.value(line);
            Object instance = readConverter.convert(singleReadContext);
            list.add(instance);
        }
        return list;
    }
}

