/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.support.csv;

import com.github.houbb.csv.api.ICsv;
import com.github.houbb.csv.api.IReadContext;
import com.github.houbb.csv.api.IWriteContext;
import com.github.houbb.csv.support.writer.ICsvWriter;
import com.github.houbb.csv.support.writer.impl.CsvWriterContext;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ThreadSafe
public class DefaultStringListCsv
implements ICsv<List<String>> {
    @Override
    public List<String> write(IWriteContext<List<String>> context) {
        List<List<String>> writeList = context.list();
        if (CollectionUtil.isEmpty(writeList) || writeList.size() <= 0) {
            return Collections.emptyList();
        }
        int size = context.list().size();
        List list = Guavas.newArrayList((int)size);
        char quoteChar = context.quoteChar();
        for (int i = 1; i < writeList.size(); ++i) {
            List<String> t = writeList.get(i);
            String writeLine = this.joinCsvLine(t, quoteChar);
            if (StringUtil.isEmpty((String)writeLine)) continue;
            list.add(writeLine);
        }
        ICsvWriter csvWriter = context.writer();
        CsvWriterContext csvWriterContext = CsvWriterContext.newInstance().writeBom(context.writeBom()).writeHead(context.writeHead()).list(list);
        boolean needWriteHead = context.writeHead();
        if (needWriteHead) {
            String headLine = this.joinCsvLine(writeList.get(0), quoteChar);
            csvWriterContext.head(headLine);
        }
        csvWriter.write(csvWriterContext);
        return list;
    }

    @Override
    public List<List<String>> read(IReadContext<List<String>> context) {
        List<String> allLines = context.reader().read();
        List readableLines = CollectionUtil.subList(allLines, (int)context.startIndex(), (int)context.endIndex());
        if (CollectionUtil.isEmpty((Collection)readableLines)) {
            return Collections.emptyList();
        }
        char quoteChar = context.quoteChar();
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        for (String line : readableLines) {
            if (StringUtil.isEmpty((String)line)) continue;
            List<String> lineSplit = this.splitCsvLine(line, quoteChar);
            resultList.add(lineSplit);
        }
        return resultList;
    }

    protected String joinCsvLine(List<String> splitList, char quoteChar) {
        if (CollectionUtil.isEmpty(splitList)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < splitList.size() - 1; ++i) {
            String field = splitList.get(i);
            String escapedField = this.getJoinEscapeField(field, quoteChar);
            stringBuilder.append(escapedField).append(",");
        }
        String lastField = splitList.get(splitList.size() - 1);
        String escapedField = this.getJoinEscapeField(lastField, quoteChar);
        stringBuilder.append(escapedField);
        return stringBuilder.toString();
    }

    protected String getJoinEscapeField(String field, char quoteChar) {
        if (field.contains(",")) {
            return quoteChar + field + quoteChar;
        }
        return field;
    }

    protected List<String> splitCsvLine(String csvData, char quoteChar) {
        ArrayList<String> result = new ArrayList<String>();
        String regex = "(?:([^" + quoteChar + ",]+)|\"([^" + quoteChar + "]*)\")";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(csvData);
        while (matcher.find()) {
            String field = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            result.add(field);
        }
        return result;
    }
}

