/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.support.writer.impl;

import com.github.houbb.csv.exception.CsvException;
import com.github.houbb.csv.support.writer.ICsvWriter;
import com.github.houbb.csv.support.writer.ICsvWriterContext;
import com.github.houbb.csv.util.CsvBomUtil;
import com.github.houbb.heaven.annotation.ThreadSafe;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;

@ThreadSafe
public class CsvWriterFilePath
implements ICsvWriter {
    private final String filePath;
    private final String charset;

    public CsvWriterFilePath(String filePath, String charset) {
        this.filePath = filePath;
        this.charset = charset;
    }

    public CsvWriterFilePath(String filePath) {
        this(filePath, "UTF-8");
    }

    @Override
    public void write(ICsvWriterContext context) {
        try {
            boolean needWriteHead;
            boolean needWriteBoom;
            boolean result;
            boolean result2;
            Path path = Paths.get(this.filePath, new String[0]);
            File parent = path.getParent().toFile();
            if (!parent.exists() && !(result2 = parent.mkdirs())) {
                throw new CsvException("File mkdirs failed!");
            }
            File file = path.toFile();
            if (!file.exists() && !(result = file.createNewFile())) {
                throw new CsvException("File create failed!");
            }
            byte[] bomBytes = CsvBomUtil.getBom(this.charset);
            boolean bl = needWriteBoom = context.writeBom() && file.length() <= 0L;
            if (needWriteBoom) {
                Files.write(path, bomBytes, StandardOpenOption.APPEND);
            }
            List<String> writeList = context.list();
            boolean bl2 = needWriteHead = context.writeHead() && file.length() <= (long)bomBytes.length;
            if (needWriteHead) {
                writeList.add(0, context.head());
            }
            Files.write(path, writeList, Charset.forName(this.charset), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new CsvException(e);
        }
    }
}

