/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.util;

import com.github.houbb.csv.bs.CsvReadBs;
import com.github.houbb.csv.bs.CsvWriteBs;
import com.github.houbb.csv.support.reader.ICsvReader;
import com.github.houbb.csv.support.reader.impl.CsvReaders;
import com.github.houbb.csv.support.writer.ICsvWriter;
import com.github.houbb.csv.support.writer.impl.CsvWriters;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public final class CsvHelper {
    private CsvHelper() {
    }

    public static <T> List<T> read(InputStream inputStream, Class<T> tClass) {
        ICsvReader reader = CsvReaders.inputStream(inputStream);
        return CsvHelper.read(reader, tClass);
    }

    public static <T> List<T> read(InputStream inputStream, String charset, Class<T> tClass) {
        ICsvReader reader = CsvReaders.inputStream(inputStream, charset);
        return CsvHelper.read(reader, tClass);
    }

    public static <T> List<T> read(File file, Class<T> tClass) {
        ICsvReader reader = CsvReaders.file(file);
        return CsvHelper.read(reader, tClass);
    }

    public static <T> List<T> read(File file, String charset, Class<T> tClass) {
        ICsvReader reader = CsvReaders.file(file, charset);
        return CsvHelper.read(reader, tClass);
    }

    public static <T> List<T> read(String filePath, Class<T> tClass) {
        ICsvReader reader = CsvReaders.filePath(filePath);
        return CsvHelper.read(reader, tClass);
    }

    public static <T> List<T> read(String filePath, String charset, Class<T> tClass) {
        ICsvReader reader = CsvReaders.filePath(filePath, charset);
        return CsvHelper.read(reader, tClass);
    }

    public static <T> List<T> read(List<String> stringList, Class<T> tClass) {
        ICsvReader reader = CsvReaders.list(stringList);
        return CsvHelper.read(reader, tClass);
    }

    public static <T> List<T> read(ICsvReader csvReader, Class<T> tClass) {
        return CsvHelper.read(csvReader, tClass, 1);
    }

    public static <T> List<T> read(ICsvReader csvReader, Class<T> tClass, int startIndex) {
        return CsvHelper.read(csvReader, tClass, startIndex, Integer.MAX_VALUE);
    }

    public static <T> List<T> read(ICsvReader csvReader, Class<T> tClass, int startIndex, int endIndex) {
        return CsvReadBs.newInstance().reader(csvReader).startIndex(startIndex).endIndex(endIndex).read(tClass);
    }

    public static <T> List<String> write(List<T> list) {
        return CsvHelper.write(list, CsvWriters.none());
    }

    public static <T> List<String> write(List<T> list, String filePath) {
        return CsvHelper.write(list, filePath, "UTF-8");
    }

    public static <T> List<String> write(List<T> list, String filePath, String charset) {
        ICsvWriter csvWriter = CsvWriters.filePath(filePath, charset);
        return CsvHelper.write(list, csvWriter);
    }

    public static <T> List<String> write(List<T> list, ICsvWriter csvWriter) {
        return CsvHelper.write(list, csvWriter, true);
    }

    public static <T> List<String> write(List<T> list, ICsvWriter csvWriter, boolean writeHead) {
        return CsvWriteBs.newInstance().writer(csvWriter).writeHead(writeHead).write(list);
    }
}

