/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.util;

import com.github.houbb.csv.exception.CsvException;
import com.github.houbb.heaven.util.lang.CharUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class CsvInnerUtil {
    private static final Map<String, String> SPECIAL_ESCAPE_MAP = new HashMap<String, String>();
    private static final Map<String, String> ESCAPE_SPECIAL_MAP = new HashMap<String, String>();

    private CsvInnerUtil() {
    }

    public static String replaceAllSpecial(String special) {
        if (StringUtil.isEmpty((String)special)) {
            return special;
        }
        String result = special;
        for (Map.Entry<String, String> entry : SPECIAL_ESCAPE_MAP.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            result = result.replaceAll(key, value);
        }
        return result;
    }

    public static String replaceAllEscape(String escape) {
        if (StringUtil.isEmpty((String)escape)) {
            return escape;
        }
        String result = escape;
        for (Map.Entry<String, String> entry : ESCAPE_SPECIAL_MAP.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            result = result.replaceAll(key, value);
        }
        return result;
    }

    public static String getNextSplit(String preSplit) {
        if (",".equals(preSplit)) {
            return ":";
        }
        if (preSplit.startsWith(":")) {
            int times = preSplit.length() + 1;
            return CharUtil.repeat((char)':', (int)times);
        }
        throw new UnsupportedOperationException("\u6682\u65f6\u4e0d\u652f\u6301\u7684\u5206\u9694\u7b26!");
    }

    public static Map<String, String> getMappingMap(String mapping) {
        if (StringUtil.isEmpty((String)mapping)) {
            return Collections.emptyMap();
        }
        String[] entryArray = mapping.split(";");
        HashMap<String, String> map = new HashMap<String, String>(entryArray.length);
        for (String entry : entryArray) {
            String[] mappings = entry.split(":");
            if (mappings.length != 2) {
                throw new CsvException("\u679a\u4e3e\u6620\u5c04\u5fc5\u987b\u4f7f\u7528\u5355\u4e2a\u3010:\u3011\u8fdb\u884c\u5206\u5272\u3002");
            }
            map.put(mappings[0], mappings[1]);
        }
        return map;
    }

    static {
        SPECIAL_ESCAPE_MAP.put(",", "&CSV_COMMA;");
        SPECIAL_ESCAPE_MAP.put("\\|", "&CSV_OR;");
        SPECIAL_ESCAPE_MAP.put(":", "&CSV_COLON;");
        SPECIAL_ESCAPE_MAP.put("=", "&CSV_EUQAL;");
        ESCAPE_SPECIAL_MAP.put("&CSV_COMMA;", ",");
        ESCAPE_SPECIAL_MAP.put("&CSV_OR;", "\\|");
        ESCAPE_SPECIAL_MAP.put("&CSV_COLON;", ":");
        ESCAPE_SPECIAL_MAP.put("&CSV_EUQAL;", "=");
    }
}

