/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.util;

import com.github.houbb.csv.bs.CsvReadBs;
import com.github.houbb.csv.bs.CsvWriteBs;
import com.github.houbb.csv.support.reader.impl.CsvReaders;
import com.github.houbb.csv.support.writer.impl.CsvWriters;
import java.util.List;

public final class CsvStringListHelper {
    public static List<List<String>> read(String filePath, int startIx, int endIx, char quoteChar) {
        return CsvReadBs.newInstance().reader(CsvReaders.filePath(filePath)).startIndex(startIx).endIndex(endIx).quoteChar(quoteChar).readStringList();
    }

    public static List<List<String>> read(String filePath, int startIx, int endIx) {
        return CsvStringListHelper.read(filePath, startIx, endIx, '\"');
    }

    public static List<List<String>> read(String filePath, int startIx) {
        return CsvStringListHelper.read(filePath, startIx, Integer.MAX_VALUE);
    }

    public static List<List<String>> read(String filePath) {
        return CsvStringListHelper.read(filePath, 0);
    }

    public static void write(String filePath, List<List<String>> dataList, char quoteChar) {
        CsvWriteBs.newInstance().writer(CsvWriters.filePath(filePath)).quoteChar(quoteChar).writeStringList(dataList);
    }

    public static void write(String filePath, List<List<String>> dataList) {
        CsvStringListHelper.write(filePath, dataList, '\"');
    }
}

