package com.github.houbb.doc.api.annotation;

/**
 * Created by bbhou on 2017/10/26.
 */

import java.lang.annotation.*;

/**
 * 自定义文档注解
 * Created by bbhou on 2017/8/28.
 */
@Documented
@Retention(RetentionPolicy.SOURCE)
@Target({ElementType.TYPE,
        ElementType.FIELD,
        ElementType.METHOD})
@Inherited
public @interface Doc {

    /**
     * 信息描述
     *
     * @return 信息描述
     */
    String value() default "";

    /**
     * 作者
     *
     * @return 作者
     */
    String author() default "";

    /**
     * 版本
     *
     * @return 作者
     */
    String version() default "";

    /**
     * JDK 版本
     *
     * @return 版本
     */
    String since() default "";

    /**
     * 修改时间
     *
     * @return 修改时间
     */
    String time() default "";

    /**
     * 标签
     *
     * @return 标签
     */
    String[] tags() default {};

}
