package com.github.houbb.hash.api;

/**
 * @author binbin.hou
 * @since 0.0.2
 */
public interface IRandomGenerator {

    /**
     * Generates a byte array of fixed length filled with random data, often useful for generating salts,
     * initialization vectors or other seed data.  The length is specified as a configuration
     * value on the underlying implementation.
     *
     * If you'd like per-invocation control the number of bytes generated, use the
     * {@link #nextBytes(int) nextBytes(int)} method instead.
     *
     * @return a byte array of fixed length filled with random data.
     * @see #nextBytes(int)
     */
    byte[] nextBytes();

    /**
     * Generates a byte array of the specified length filled with random data.
     *
     * @param numBytes the number of bytes to be populated with random data.
     * @return a byte array of the specified length filled with random data.
     * @see #nextBytes()
     */
    byte[] nextBytes(int numBytes);

}
