package com.github.houbb.hash.bs;

import com.github.houbb.hash.api.IHash;
import com.github.houbb.hash.api.IHashContext;
import com.github.houbb.hash.api.IHashResult;
import com.github.houbb.hash.api.IHashResultHandler;
import com.github.houbb.hash.constant.enums.HashType;
import com.github.houbb.hash.core.hash.context.HashContext;
import com.github.houbb.hash.core.hash.result.Hash;

/**
 * @author binbin.hou
 * @since 0.0.2
 */
public final class HashBs {

    private HashBs() {
    }

    public static HashBs newInstance() {
        return new HashBs();
    }

    /**
     * 核心 hash 类型
     *
     * @since 0.0.2
     */
    private HashType type = HashType.MD5;

    /**
     * 重复次数
     *
     * @since 0.0.2
     */
    private int times = 1;

    /**
     * 原始值
     *
     * @since 0.0.2
     */
    private byte[] source;

    /**
     * 盐
     *
     * @since 0.0.2
     */
    private byte[] salt;

    public HashBs type(HashType type) {
        this.type = type;
        return this;
    }

    public HashBs times(int times) {
        this.times = times;
        return this;
    }

    public HashBs source(byte[] source) {
        this.source = source;
        return this;
    }

    public HashBs salt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    /**
     * 执行
     *
     * @param handler 处理类
     * @param <T>     泛型
     * @return 结果
     * @since 0.0.2
     */
    public <T> T execute(final IHashResultHandler<T> handler) {
        IHash hash = new Hash();
        IHashContext context = HashContext.newInstance()
                .algorithmName(type.getCode())
                .salt(salt)
                .source(source)
                .times(times);

        IHashResult result = hash.hash(context);
        return handler.handle(result);
    }

}
