package com.github.houbb.hash.constant.enums;

/**
 * HASH 的类型
 * @author binbin.hou
 * @since 0.0.2
 */
public enum HashType {
    /**
     * 类型
     */
    MD2("MD2"),
    MD5("MD5"),
    SHA1("SHA-1"),
    SHA256("SHA-256"),
    SHA384("SHA-384"),
    SHA512("SHA-512"),
    ;

    private final String code;

    HashType(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String toString() {
        return "HashType{" +
                "code='" + code + '\'' +
                '}';
    }

}
