package com.github.houbb.hash.core.code;

import com.github.houbb.hash.api.IHashCode;

/**
 * @author binbin.hou
 * @since 0.0.1
 */
public abstract class AbstractHashCode implements IHashCode {

    @Override
    public int hash(String text) {
        if(null == text) {
            return 0;
        }

        return doHash(text);
    }

    /**
     * 执行真正的 hash 策略
     * @param text 文本
     * @return 结果
     * @since 0.0.1
     */
    protected abstract int doHash(final String text);

}
