package com.github.houbb.hash.core.code;

import com.github.houbb.heaven.annotation.ThreadSafe;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/**
 * @author binbin.hou
 * @since 0.0.1
 */
@ThreadSafe
public class HashCodeMurmur extends AbstractHashCode {

    @Override
    public int doHash(String text) {
        ByteBuffer buf = ByteBuffer.wrap(text.getBytes());
        int seed = 0x1234ABCD;

        ByteOrder byteOrder = buf.order();
        buf.order(ByteOrder.LITTLE_ENDIAN);

        long m = 0xc6a4a7935bd1e995L;
        int r = 47;

        long h = seed ^ (buf.remaining() * m);

        long k;
        while (buf.remaining() >= 8) {
            k = buf.getLong();

            k *= m;
            k ^= k >>> r;
            k *= m;

            h ^= k;
            h *= m;
        }

        if (buf.remaining() > 0) {
            ByteBuffer finish = ByteBuffer.allocate(8).order(
                    ByteOrder.LITTLE_ENDIAN);
            // for big-endian version, do this first:
            // finish.position(8-buf.remaining());
            finish.put(buf).rewind();
            h ^= finish.getLong();
            h *= m;
        }
        h ^= h >>> r;
        h *= m;
        h ^= h >>> r;

        buf.order(byteOrder);
        return (int) (h & 0xffffffffL);
    }

}
