package com.github.houbb.hash.core.handler;

import com.github.houbb.hash.api.IHashResult;
import com.github.houbb.hash.api.IHashResultHandler;
import com.github.houbb.heaven.support.instance.impl.Instances;

/**
 * @author binbin.hou
 * @since 1.0.0
 */
public final class HashResultHandlers {

    private HashResultHandlers(){}

    /**
     * hex 算法
     * @return 结果
     * @since 0.0.2
     */
    public static IHashResultHandler<String> hex() {
        return Instances.singleton(HexHashResultHandler.class);
    }

    /**
     * base64 算法
     * @return 结果
     * @since 0.0.2
     */
    public static IHashResultHandler<String> base64() {
        return Instances.singleton(Base64HashResultHandler.class);
    }

    /**
     * 默认算法
     * @return 结果
     * @since 0.0.2
     */
    public static IHashResultHandler<IHashResult> defaults() {
        return Instances.singleton(DefaultHashResultHandler.class);
    }

    /**
     * bytes 算法
     * @return 结果
     * @since 0.0.2
     */
    public static IHashResultHandler<byte[]> bytes() {
        return Instances.singleton(BytesHashResultHandler.class);
    }

}
