package com.github.houbb.hash.core.handler;

import com.github.houbb.hash.api.IHashResult;
import com.github.houbb.hash.api.IHashResultHandler;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.codec.CodecSupport;
import com.github.houbb.heaven.util.codec.Hex;

/**
 * @author binbin.hou
 * @since 1.0.0
 */
@ThreadSafe
public class HexHashResultHandler implements IHashResultHandler<String> {
    @Override
    public String handle(IHashResult hashResult) {
        return Hex.encodeToString(hashResult.hashed());
    }
}
