package com.github.houbb.hash.core.hash.context;

import com.github.houbb.hash.api.IHashContext;

import java.util.Arrays;

/**
 * hash 上下文
 * @author binbin.hou
 * @since 1.0.0
 */
public class HashContext implements IHashContext {

    /**
     * 源头
     * @since 0.0.2
     */
    private byte[] source;

    /**
     * 盐
     * @since 0.0.2
     */
    private byte[] salt;

    /**
     * 算法名称
     * @since 0.0.2
     */
    private String algorithmName;

    /**
     * 迭代次数
     * @since 0.0.2
     */
    private int times;

    public static HashContext newInstance() {
        return new HashContext();
    }

    @Override
    public byte[] source() {
        return source;
    }

    public HashContext source(byte[] source) {
        this.source = source;
        return this;
    }

    @Override
    public byte[] salt() {
        return salt;
    }

    public HashContext salt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    @Override
    public String algorithmName() {
        return algorithmName;
    }

    public HashContext algorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    @Override
    public int times() {
        return times;
    }

    public HashContext times(int times) {
        this.times = times;
        return this;
    }

    @Override
    public String toString() {
        return "HashContext{" +
                "source=" + Arrays.toString(source) +
                ", salt=" + Arrays.toString(salt) +
                ", algorithmName='" + algorithmName + '\'' +
                ", iterations=" + times +
                '}';
    }

}
