package com.github.houbb.hash.core.hash.result;

import com.github.houbb.hash.api.IHashResult;

import java.util.Arrays;

/**
 * @author binbin.hou
 * @since 0.0.2
 */
public class HashResult implements IHashResult {

    public static HashResult newInstance() {
        return new HashResult();
    }

    /**
     * 字节数组
     * @since 0.0.2
     */
    private byte[] hashed;

    @Override
    public byte[] hashed() {
        return hashed;
    }

    public HashResult hashed(byte[] hashed) {
        this.hashed = hashed;
        return this;
    }

    @Override
    public String toString() {
        return "HashResult{" +
                "hashed=" + Arrays.toString(hashed) +
                '}';
    }

}
