package com.github.houbb.hash.core.random;

import com.github.houbb.hash.api.IRandomGenerator;

import java.security.SecureRandom;

/**
 * @author binbin.hou
 * @since 0.0.2
 */
public class SecureRandomGenerator implements IRandomGenerator {

    //16 bytes == 128 bits (a common number in crypto)
    protected static final int DEFAULT_NEXT_BYTES_SIZE = 16;

    private int defaultNextBytesSize;

    private SecureRandom secureRandom;

    public SecureRandomGenerator() {
        this.defaultNextBytesSize = DEFAULT_NEXT_BYTES_SIZE;
        this.secureRandom = new SecureRandom();
    }

    @Override
    public byte[] nextBytes() {
        return nextBytes(defaultNextBytesSize);
    }

    @Override
    public byte[] nextBytes(int numBytes) {
        if (numBytes <= 0) {
            throw new IllegalArgumentException("numBytes argument must be a positive integer (1 or larger)");
        }
        byte[] bytes = new byte[numBytes];
        this.secureRandom.nextBytes(bytes);
        return bytes;
    }

}
