package com.github.houbb.hash.util;

import com.github.houbb.hash.core.code.HasheCodes;

/**
 * 哈希编码工具类
 * @author binbin.hou
 * @since 0.0.1
 */
public final class HashCodeHelper {

    private HashCodeHelper(){}

    /**
     * jdk hash 策略
     * @param text 文本
     * @return 结果
     * @since 0.0.1
     */
    public static int jdk(final String text) {
        return HasheCodes.jdk().hash(text);
    }

    /**
     * crc hash 策略
     * @param text 文本
     * @return 结果
     * @since 0.0.1
     */
    public static int crc(final String text) {
        return HasheCodes.crc().hash(text);
    }

    /**
     * fnv hash 策略
     * @param text 文本
     * @return 结果
     * @since 0.0.1
     */
    public static int fnv(final String text) {
        return HasheCodes.fnv().hash(text);
    }

    /**
     * ketama hash 策略
     * @param text 文本
     * @return 结果
     * @since 0.0.1
     */
    public static int ketama(final String text) {
        return HasheCodes.ketama().hash(text);
    }

    /**
     * murmur hash 策略
     * @param text 文本
     * @return 结果
     * @since 0.0.1
     */
    public static int murmur(final String text) {
        return HasheCodes.murmur().hash(text);
    }

}
