/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.hash.bs;

import com.github.houbb.hash.api.IHashResult;
import com.github.houbb.hash.api.IHashResultHandler;
import com.github.houbb.hash.constant.enums.HashType;
import com.github.houbb.hash.core.hash.context.HashContext;
import com.github.houbb.hash.core.hash.result.Hash;

public final class HashBs {
    private HashType type = HashType.MD5;
    private int times = 1;
    private byte[] source;
    private byte[] salt;

    private HashBs() {
    }

    public static HashBs newInstance() {
        return new HashBs();
    }

    public HashBs type(HashType type) {
        this.type = type;
        return this;
    }

    public HashBs times(int times) {
        this.times = times;
        return this;
    }

    public HashBs source(byte[] source) {
        this.source = source;
        return this;
    }

    public HashBs salt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    public <T> T execute(IHashResultHandler<T> handler) {
        Hash hash = new Hash();
        HashContext context = HashContext.newInstance().algorithmName(this.type.getCode()).salt(this.salt).source(this.source).times(this.times);
        IHashResult result = hash.hash(context);
        return handler.handle(result);
    }
}

