/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.hash.core.hash.result;

import com.github.houbb.hash.api.IHash;
import com.github.houbb.hash.api.IHashContext;
import com.github.houbb.hash.api.IHashResult;
import com.github.houbb.hash.core.hash.result.HashResult;
import com.github.houbb.hash.exception.HashRuntimeException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Hash
implements IHash {
    @Override
    public IHashResult hash(IHashContext context) {
        byte[] hashed = this.hash(context.source(), context.salt(), context.times(), context.algorithmName());
        return HashResult.newInstance().hashed(hashed);
    }

    protected MessageDigest getDigest(String algorithmName) {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "No native '" + algorithmName + "' MessageDigest instance available on the current JVM.";
            throw new HashRuntimeException(msg, e);
        }
    }

    protected byte[] hash(byte[] bytes, byte[] salt, int hashIterations, String algorithmName) {
        MessageDigest digest = this.getDigest(algorithmName);
        if (salt != null) {
            digest.reset();
            digest.update(salt);
        }
        byte[] hashed = digest.digest(bytes);
        int times = hashIterations - 1;
        for (int i = 0; i < times; ++i) {
            digest.reset();
            hashed = digest.digest(hashed);
        }
        return hashed;
    }
}

