/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.hash.util;

import com.github.houbb.hash.api.IHashResultHandler;
import com.github.houbb.hash.bs.HashBs;
import com.github.houbb.hash.constant.enums.HashType;
import com.github.houbb.hash.core.handler.HashResultHandlers;
import com.github.houbb.heaven.util.codec.CodecSupport;

public final class HashHelper {
    private HashHelper() {
    }

    public static String hash(String text) {
        return HashHelper.hash(HashType.MD5, text);
    }

    public static String hash(HashType type, String text) {
        return HashHelper.hash(type, text, HashResultHandlers.hex());
    }

    public static <T> T hash(HashType type, String text, IHashResultHandler<T> hashResultHandler) {
        return HashHelper.hash(type, text, null, hashResultHandler);
    }

    public static <T> T hash(HashType type, String text, String salt, IHashResultHandler<T> hashResultHandler) {
        return HashHelper.hash(type, text, salt, 1, hashResultHandler);
    }

    public static <T> T hash(HashType type, String text, String salt, int times, IHashResultHandler<T> hashResultHandler) {
        return HashBs.newInstance().type(type).source(CodecSupport.toBytes((String)text)).salt(CodecSupport.toBytes((String)salt)).times(times).execute(hashResultHandler);
    }
}

