/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang;

import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.ArrayPrimitiveUtil;
import com.github.houbb.heaven.util.util.Optional;

public final class NumUtil {
    public static final char[] HEX_CHARS = "1234567890abcdefABCDEF".toCharArray();

    private NumUtil() {
    }

    public static int getMin(int current, int other) {
        return current > other ? other : current;
    }

    public static int getMax(int current, int other) {
        return current > other ? current : other;
    }

    public static Optional<Integer> toInteger(String string) {
        if (StringUtil.isEmpty(string)) {
            return Optional.empty();
        }
        try {
            Integer integer = Integer.valueOf(string);
            return Optional.of(integer);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<Long> toLong(String string) {
        if (StringUtil.isEmpty(string)) {
            return Optional.empty();
        }
        try {
            Long aLong = Long.valueOf(string);
            return Optional.of(aLong);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<Double> toDouble(String string) {
        if (StringUtil.isEmpty(string)) {
            return Optional.empty();
        }
        try {
            Double aDouble = Double.valueOf(string);
            return Optional.of(aDouble);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static boolean isHex(String string) {
        char[] chars;
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        for (char c : chars = string.toCharArray()) {
            if (ArrayPrimitiveUtil.indexOf(HEX_CHARS, c) >= 0) continue;
            return false;
        }
        return true;
    }
}

