/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang.reflect;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.lang.reflect.PrimitiveUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import sun.reflect.generics.reflectiveObjects.WildcardTypeImpl;

public final class ReflectFieldUtil {
    private ReflectFieldUtil() {
    }

    public static boolean isAssignable(Field sourceField, Field targetField) {
        Class<?> targetType;
        if (ObjectUtil.isNull(sourceField) || ObjectUtil.isNull(targetField)) {
            return false;
        }
        if (Modifier.isFinal(targetField.getModifiers())) {
            return false;
        }
        Class<?> sourceType = sourceField.getType();
        if (sourceType.isAssignableFrom(targetType = targetField.getType())) {
            return true;
        }
        if (sourceType.isPrimitive()) {
            Class<?> resolvedPrimitive = PrimitiveUtil.getPrimitiveType(targetType);
            return sourceType == resolvedPrimitive;
        }
        Class<?> resolvedPrimitive = PrimitiveUtil.getPrimitiveType(targetType);
        return resolvedPrimitive != null && sourceType.isAssignableFrom(resolvedPrimitive);
    }

    public static Boolean isString(Field field) {
        return field.getType() == String.class;
    }

    public static Boolean isNotString(Field field) {
        return ReflectFieldUtil.isString(field) == false;
    }

    public static boolean isAnnotationPresent(Field field, Class<? extends Annotation> clazz) {
        return field.isAnnotationPresent(clazz);
    }

    public static boolean isNotAnnotationPresent(Field field, Class<? extends Annotation> clazz) {
        return !ReflectFieldUtil.isAnnotationPresent(field, clazz);
    }

    public static Class getGenericParamType(Field field, int paramIndex) {
        if (ObjectUtil.isNull(field)) {
            return null;
        }
        field.setAccessible(true);
        Type genericType = field.getGenericType();
        if (ObjectUtil.isNull(genericType)) {
            return null;
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Object[] types = parameterizedType.getActualTypeArguments();
            if (ArrayUtil.isEmpty(types)) {
                return null;
            }
            Object type = types[paramIndex];
            if (ClassTypeUtil.isWildcardGenericType((Type)type)) {
                WildcardTypeImpl wildcardType = (WildcardTypeImpl)type;
                Object[] lowerBounds = wildcardType.getLowerBounds();
                if (ArrayUtil.isNotEmpty(lowerBounds)) {
                    return (Class)lowerBounds[0];
                }
                Object[] upperBounds = wildcardType.getUpperBounds();
                if (ArrayUtil.isNotEmpty(upperBounds)) {
                    return (Class)upperBounds[0];
                }
                return Object.class;
            }
            return (Class)type;
        }
        return null;
    }

    public static boolean containsAnnotationField(Class clazz, Class<? extends Annotation> annotationClass) {
        ArgUtil.notNull(clazz, "Clazz");
        ArgUtil.notNull(annotationClass, "Annotation class");
        List<Field> fieldList = ClassUtil.getAllFieldList(clazz);
        if (CollectionUtil.isEmpty(fieldList)) {
            return false;
        }
        for (Field field : fieldList) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            return true;
        }
        return false;
    }

    public static Class getComponentType(Field field, int typeIndex) {
        Class<?> fieldType = field.getType();
        if (ClassTypeUtil.isArray(fieldType)) {
            return fieldType.getComponentType();
        }
        if (ClassTypeUtil.isCollection(fieldType)) {
            return ReflectFieldUtil.getGenericParamType(field, 0);
        }
        if (ClassTypeUtil.isMap(fieldType)) {
            return ReflectFieldUtil.getGenericParamType(field, typeIndex);
        }
        return fieldType;
    }

    public static Class getComponentType(Field field) {
        return ReflectFieldUtil.getComponentType(field, 0);
    }

    public static void setValue(Field field, Object instance, Object fieldValue) {
        try {
            field.setAccessible(true);
            field.set(instance, fieldValue);
        }
        catch (IllegalAccessException e) {
            throw new CommonRuntimeException(e);
        }
    }
}

