/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.net;

import java.net.InetAddress;
import java.net.UnknownHostException;

public final class NetUtil {
    private NetUtil() {
    }

    public static boolean isReachable(String remoteInetAddress) {
        return NetUtil.isReachable(remoteInetAddress, 5000);
    }

    public static boolean isReachable(String remoteInetAddress, int timeoutInMills) {
        boolean reachable = false;
        try {
            InetAddress address = InetAddress.getByName(remoteInetAddress);
            reachable = address.isReachable(timeoutInMills);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reachable;
    }

    public static void assertOnLine() {
        String address = "translate.google.cn";
        try {
            InetAddress inetAddress = InetAddress.getByName("translate.google.cn");
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("The net work is broken, check your network or set isCommentWhenNetworkBroken=true.");
        }
    }
}

