/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.guava;

import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class Guavas {
    private Guavas() {
    }

    public static <E> List<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> List<E> newArrayList(int size) {
        return new ArrayList(size);
    }

    public static <E> List<E> newArrayList(E ... elems) {
        if (ArrayUtil.isEmpty(elems)) {
            return new ArrayList();
        }
        List<E> list = Guavas.newArrayList(elems.length);
        list.addAll(Arrays.asList(elems));
        return list;
    }

    public static <E> List<E> newArrayList(Collection<E> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        List<E> list = Guavas.newArrayList(collection.size());
        list.addAll(collection);
        return list;
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newHashMap(int size) {
        return new HashMap(size);
    }

    public static <K, V> Map<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <E> Set<E> newHashSet() {
        return new HashSet();
    }

    public static <E> Set<E> newHashSet(int size) {
        return new HashSet(size);
    }
}

