/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.io;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class StreamUtil {
    private StreamUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toString(InputStream is, String charset) {
        try (ByteArrayOutputStream boa = new ByteArrayOutputStream();){
            int len = 0;
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                boa.write(buffer, 0, len);
            }
            byte[] result = boa.toByteArray();
            String string = new String(result, charset);
            return string;
        }
        catch (Exception e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static String toString(InputStream is) {
        return StreamUtil.toString(is, "UTF-8");
    }
}

