/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.ArrayPrimitiveUtil;
import com.github.houbb.heaven.util.util.Optional;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class NumUtil {
    public static final char[] HEX_CHARS = "1234567890abcdefABCDEF".toCharArray();

    private NumUtil() {
    }

    public static int getMin(int current, int other) {
        return current > other ? other : current;
    }

    public static int getMax(int current, int other) {
        return current > other ? current : other;
    }

    public static Optional<Integer> toInteger(String string) {
        if (StringUtil.isEmpty(string)) {
            return Optional.empty();
        }
        try {
            Integer integer = Integer.valueOf(string);
            return Optional.of(integer);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Integer toIntegerThrows(String string) {
        ArgUtil.notEmpty(string, "string");
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    public static int toInteger(String string, int defaultValue) {
        try {
            return Integer.valueOf(string);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Optional<Long> toLong(String string) {
        if (StringUtil.isEmpty(string)) {
            return Optional.empty();
        }
        try {
            Long aLong = Long.valueOf(string);
            return Optional.of(aLong);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<Double> toDouble(String string) {
        if (StringUtil.isEmpty(string)) {
            return Optional.empty();
        }
        try {
            Double aDouble = Double.valueOf(string);
            return Optional.of(aDouble);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static boolean isHex(String string) {
        char[] chars;
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        for (char c : chars = string.toCharArray()) {
            if (ArrayPrimitiveUtil.indexOf(HEX_CHARS, c) >= 0) continue;
            return false;
        }
        return true;
    }

    public static Long parseLong(Object object) {
        if (ObjectUtil.isNull(object)) {
            return null;
        }
        Class<?> valueClass = object.getClass();
        if (object instanceof Byte || valueClass == Byte.TYPE) {
            Byte aByte = (Byte)object;
            return aByte.longValue();
        }
        if (object instanceof Short || valueClass == Short.TYPE) {
            Short aShort = (Short)object;
            return aShort.longValue();
        }
        if (object instanceof Integer || valueClass == Integer.TYPE) {
            Integer integer = (Integer)object;
            return integer.longValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            return Long.parseLong(charSequence.toString());
        }
        if (object instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)object;
            return bigInteger.longValue();
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return bigDecimal.longValue();
        }
        throw new ClassCastException("Class cast exception for parse long with object: " + object);
    }
}

