/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang;

import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.CharUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;
import com.github.houbb.heaven.util.util.ArrayPrimitiveUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class StringUtil {
    public static final String EMPTY = "";
    public static final String BLANK = " ";

    private StringUtil() {
    }

    public static boolean isUpperCase(String string) {
        char[] characters;
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        for (char c : characters = string.toCharArray()) {
            if (Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(String string) {
        char[] characters;
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        for (char c : characters = string.toCharArray()) {
            if (Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsUppercase(String string) {
        char[] characters;
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        for (char c : characters = string.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsLowercase(String string) {
        char[] characters;
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        for (char c : characters = string.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(String string) {
        return null == string || EMPTY.equals(string);
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtil.isEmpty(string);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtil.isBlank(str);
    }

    public static String[] splitByAnyBlank(String string) {
        if (StringUtil.isEmpty(string)) {
            return new String[0];
        }
        String pattern = "\\s+";
        return string.split("\\s+");
    }

    public static String getCamelCaseString(String inputString, boolean firstCharacterUppercase) {
        StringBuilder sb = new StringBuilder();
        boolean nextUpperCase = false;
        block3: for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            switch (c) {
                case ' ': 
                case '#': 
                case '$': 
                case '&': 
                case '-': 
                case '/': 
                case '@': 
                case '_': {
                    if (sb.length() <= 0) continue block3;
                    nextUpperCase = true;
                    continue block3;
                }
                default: {
                    if (nextUpperCase) {
                        sb.append(Character.toUpperCase(c));
                        nextUpperCase = false;
                        continue block3;
                    }
                    sb.append(Character.toLowerCase(c));
                }
            }
        }
        if (firstCharacterUppercase) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    public static String firstToLowerCase(String str) {
        if (str == null || str.trim().length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String firstToUpperCase(String str) {
        if (str == null || str.trim().length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String defaultEmpty(String string) {
        if (StringUtil.isEmpty(string)) {
            return EMPTY;
        }
        return string;
    }

    public static String join(Object[] array, String separator) {
        int endIndex = ArrayUtil.getEndIndex(-1, array);
        return StringUtil.join(array, separator, 0, endIndex);
    }

    public static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int noOfItems;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        if ((noOfItems = endIndex - startIndex) <= 0) {
            return EMPTY;
        }
        StringBuilder buf = new StringBuilder(noOfItems * 16);
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static <E> String join(Collection<E> collection, String splitter, int startIndex, int endIndex) {
        int i;
        if (CollectionUtil.isEmpty(collection)) {
            return EMPTY;
        }
        String actualSplitter = StringUtil.nullToDefault(splitter, EMPTY);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<E> iterator = collection.iterator();
        for (i = 0; i < startIndex; ++i) {
            iterator.next();
        }
        stringBuilder.append(iterator.next().toString());
        for (i = startIndex; i < endIndex; ++i) {
            stringBuilder.append(actualSplitter).append(iterator.next().toString());
        }
        return stringBuilder.toString();
    }

    public static <E> String join(Collection<E> collection, String splitter) {
        int endIndex = CollectionUtil.getEndIndex(-1, collection);
        return StringUtil.join(collection, splitter, 0, endIndex);
    }

    public static String camelToUnderline(String camelStr) {
        char[] chars;
        if (StringUtil.isEmpty(camelStr)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : chars = camelStr.toCharArray()) {
            if (Character.isUpperCase(c)) {
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlineToCamel(String underlineStr) {
        if (StringUtil.isEmpty(underlineStr)) {
            return EMPTY;
        }
        int len = underlineStr.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = underlineStr.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(underlineStr.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String repeat(String component, int times) {
        if (StringUtil.isEmpty(component) || times <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            stringBuffer.append(component);
        }
        return stringBuffer.toString();
    }

    public static String buildString(Object original, String middle, int prefixLength) {
        if (ObjectUtil.isNull(original)) {
            return null;
        }
        String string = original.toString();
        int stringLength = string.length();
        String prefix = EMPTY;
        String suffix = EMPTY;
        prefix = stringLength >= prefixLength ? string.substring(0, prefixLength) : string.substring(0, stringLength);
        int suffixLength = stringLength - prefix.length() - middle.length();
        if (suffixLength > 0) {
            suffix = string.substring(stringLength - suffixLength);
        }
        return prefix + middle + suffix;
    }

    public static String trim(String original) {
        if (StringUtil.isBlank(original)) {
            return original;
        }
        return original.trim();
    }

    public static String nullToDefault(CharSequence str, String defaultStr) {
        return str == null ? defaultStr : str.toString();
    }

    public static String fill(String str, char filledChar, int len, boolean isPre) {
        int strLen = str.length();
        if (strLen > len) {
            return str;
        }
        String filledStr = StringUtil.repeat(String.valueOf(filledChar), len - strLen);
        return isPre ? filledStr.concat(str) : str.concat(filledStr);
    }

    public static String objectToString(Object object, String defaultWhenNull) {
        if (ObjectUtil.isNull(object)) {
            return defaultWhenNull;
        }
        Class<?> type = object.getClass();
        if (ClassTypeUtil.isArray(type)) {
            Object[] arrays = (Object[])object;
            return Arrays.toString(arrays);
        }
        return object.toString();
    }

    public static String objectToString(Object object) {
        return StringUtil.objectToString(object, null);
    }

    @Deprecated
    public static String times(String single, int times) {
        if (StringUtil.isEmpty(single)) {
            return single;
        }
        if (times <= 0) {
            return single;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            stringBuilder.append(single);
        }
        return stringBuilder.toString();
    }

    public static String capitalFirst(String string) {
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        if (string.length() <= 1) {
            return string.toUpperCase();
        }
        char capitalChar = Character.toUpperCase(string.charAt(0));
        return capitalChar + string.substring(1);
    }

    public static List<String> splitStrictly(String string, char splitUnit, int times) {
        if (StringUtil.isEmpty(string)) {
            return Collections.emptyList();
        }
        if (times <= 0) {
            return Collections.singletonList(string);
        }
        String split = CharUtil.repeat(splitUnit, times);
        String moreSplit = CharUtil.repeat(splitUnit, times + 1);
        List<Integer> splitIndexList = StringUtil.getIndexList(string, split);
        List<Integer> moreSplitIndexList = StringUtil.getIndexList(string, moreSplit);
        List<Integer> removeIndexList = StringUtil.getSerialFilterList(splitIndexList, moreSplitIndexList, times);
        List<Integer> trimIndexList = CollectionUtil.difference(splitIndexList, removeIndexList);
        return StringUtil.subStringList(string, trimIndexList, times);
    }

    private static List<Integer> getSerialFilterList(List<Integer> allList, List<Integer> filterList, int step) {
        List<Integer> resultList = Guavas.newArrayList();
        resultList.addAll(filterList);
        for (Integer filter : filterList) {
            int nextVal;
            Integer indexVal;
            int startIndex = allList.indexOf(filter) + 1;
            int stepTimes = 1;
            for (int i = startIndex; i < allList.size() && (indexVal = allList.get(i)).equals(nextVal = step * stepTimes + filter); ++i) {
                resultList.add(nextVal);
                ++stepTimes;
            }
        }
        return resultList;
    }

    public static List<String> subStringList(String string, Collection<Integer> indexCollection, int ignoreLength) {
        if (StringUtil.isEmpty(string)) {
            return Collections.emptyList();
        }
        if (CollectionUtil.isEmpty(indexCollection)) {
            return Collections.singletonList(string);
        }
        List<String> resultList = Guavas.newArrayList(indexCollection.size());
        int startIndex = 0;
        for (Integer index : indexCollection) {
            if (startIndex > string.length() - 1) {
                resultList.add(EMPTY);
                break;
            }
            String subString = string.substring(startIndex, index);
            resultList.add(subString);
            startIndex = index + ignoreLength;
        }
        if (startIndex < string.length()) {
            String subString = string.substring(startIndex);
            resultList.add(subString);
        }
        return resultList;
    }

    public static List<Integer> getIndexList(String string, String split) {
        if (StringUtil.isEmpty(string) || StringUtil.isEmpty(split)) {
            return Collections.emptyList();
        }
        List<Integer> indexList = Guavas.newArrayList();
        for (int startIndex = 0; startIndex < string.length() && (startIndex = string.indexOf(split, startIndex)) >= 0; startIndex += split.length()) {
            indexList.add(startIndex);
        }
        return indexList;
    }

    public static List<Integer> getIndexList(String string, char symbol, boolean ignoreDoubleQuotes) {
        if (StringUtil.isEmpty(string)) {
            return Collections.emptyList();
        }
        List<Integer> resultList = Guavas.newArrayList();
        char[] chars = string.toCharArray();
        boolean doubleQuotesStart = false;
        char preChar = ' ';
        for (int i = 0; i < chars.length; ++i) {
            char currentChar = chars[i];
            if ('\\' != (preChar = StringUtil.getPreChar(preChar, currentChar)) && '\"' == currentChar) {
                boolean bl = doubleQuotesStart = !doubleQuotesStart;
            }
            if (currentChar != symbol) continue;
            if (ignoreDoubleQuotes) {
                if (doubleQuotesStart) continue;
                resultList.add(i);
                continue;
            }
            resultList.add(i);
        }
        return resultList;
    }

    @Deprecated
    private static char getPreChar(char preChar, char currentChar) {
        if ('\\' == preChar && '\\' == currentChar) {
            return ' ';
        }
        return currentChar;
    }

    public static List<String> splitByIndexes(String string, List<Integer> indexList) {
        if (StringUtil.isEmpty(string)) {
            return Collections.emptyList();
        }
        if (CollectionUtil.isEmpty(indexList)) {
            return Collections.singletonList(string);
        }
        List<String> resultList = Guavas.newArrayList(indexList.size() + 1);
        int preIndex = 0;
        for (Integer anIndexList : indexList) {
            int currentIndex = anIndexList;
            if (currentIndex > preIndex) {
                resultList.add(string.substring(preIndex, currentIndex));
            }
            preIndex = currentIndex + 1;
        }
        int lastIndex = indexList.get(indexList.size() - 1);
        if (lastIndex + 1 < string.length()) {
            resultList.add(string.substring(lastIndex + 1));
        }
        return resultList;
    }

    public static byte[] stringToBytes(String string) {
        if (ObjectUtil.isNull(string)) {
            return null;
        }
        return string.getBytes();
    }

    public static String bytesToString(byte[] bytes) {
        if (ArrayPrimitiveUtil.isEmpty(bytes)) {
            return null;
        }
        return new String(bytes);
    }
}

