/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang.reflect;

import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;

public final class ReflectAnnotationUtil {
    private ReflectAnnotationUtil() {
    }

    public static void updateValue(Annotation annotation, String method, Object value) {
        Map<String, Object> memberValues = ReflectAnnotationUtil.getAnnotationMap(annotation);
        memberValues.put(method, value);
    }

    public static Object getValue(Annotation annotation, String method) {
        Map<String, Object> memberValues = ReflectAnnotationUtil.getAnnotationMap(annotation);
        return memberValues.get(method);
    }

    public static String getValueStr(Annotation annotation, String method) {
        Map<String, Object> memberValues = ReflectAnnotationUtil.getAnnotationMap(annotation);
        Object object = memberValues.get(method);
        return ObjectUtil.objectToString(object);
    }

    private static Map<String, Object> getAnnotationMap(Annotation annotation) {
        try {
            InvocationHandler h = Proxy.getInvocationHandler(annotation);
            Field hField = h.getClass().getDeclaredField("memberValues");
            hField.setAccessible(true);
            return (Map)hField.get(h);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<Annotation> getAnnotation(Annotation annotation, Class<? extends Annotation> annotationClass) {
        if (ObjectUtil.isNull(annotation) || ObjectUtil.isNull(annotationClass)) {
            return Optional.empty();
        }
        Annotation atAnnotation = annotation.annotationType().getAnnotation(annotationClass);
        if (ObjectUtil.isNotNull(atAnnotation)) {
            return Optional.of(atAnnotation);
        }
        return Optional.empty();
    }
}

