/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang.reflect;

import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class ReflectMethodUtil {
    private static final List<String> IGNORE_METHOD_LIST;

    private ReflectMethodUtil() {
    }

    public static List<String> getIgnoreMethodList() {
        return IGNORE_METHOD_LIST;
    }

    public static boolean isIgnoreMethod(String methodName) {
        return ReflectMethodUtil.getIgnoreMethodList().contains(methodName);
    }

    public static List<String> getParamTypeNames(Method method) {
        ArgUtil.notNull(method, "method");
        Class<?>[] paramTypes = method.getParameterTypes();
        return ArrayUtil.toList(paramTypes, new IHandler<Class<?>, String>(){

            @Override
            public String handle(Class<?> aClass) {
                return aClass.getName();
            }
        });
    }

    public static Class getReturnGenericType(Method method, int index) {
        Type returnType = method.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)returnType;
            Type[] typeArguments = type.getActualTypeArguments();
            return (Class)typeArguments[index];
        }
        return null;
    }

    public static Class getParamGenericType(Method method, int paramIndex, int genericIndex) {
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Type genericParameterType = genericParameterTypes[paramIndex];
        if (genericParameterType instanceof ParameterizedType) {
            ParameterizedType aType = (ParameterizedType)genericParameterType;
            Type[] parameterArgTypes = aType.getActualTypeArguments();
            return (Class)parameterArgTypes[genericIndex];
        }
        return null;
    }

    static {
        HashSet<String> methodNameSet = new HashSet<String>(64);
        for (Method method : Object.class.getMethods()) {
            methodNameSet.add(method.getName());
        }
        for (Method method : Class.class.getMethods()) {
            methodNameSet.add(method.getName());
        }
        IGNORE_METHOD_LIST = new ArrayList<String>(methodNameSet);
    }
}

