/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang.reflect;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.support.tuple.impl.Pair;
import com.github.houbb.heaven.util.lang.reflect.GenericArrayTypeImpl;
import com.github.houbb.heaven.util.lang.reflect.ParameterizedTypeImpl;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class TypeUtil {
    private TypeUtil() {
    }

    public static Collection createCollection(Type type) {
        return TypeUtil.createCollection(type, 8);
    }

    public static Map<Object, Object> createMap(Type type) {
        if (type == Properties.class) {
            return new Properties();
        }
        if (type == Hashtable.class) {
            return new Hashtable<Object, Object>();
        }
        if (type == IdentityHashMap.class) {
            return new IdentityHashMap<Object, Object>();
        }
        if (type == SortedMap.class || type == TreeMap.class) {
            return new TreeMap<Object, Object>();
        }
        if (type == ConcurrentMap.class || type == ConcurrentHashMap.class) {
            return new ConcurrentHashMap<Object, Object>();
        }
        if (type == HashMap.class) {
            return new HashMap<Object, Object>();
        }
        if (type == LinkedHashMap.class) {
            return new LinkedHashMap<Object, Object>();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (EnumMap.class.equals((Object)rawType)) {
                Type[] actualArgs = parameterizedType.getActualTypeArguments();
                return new EnumMap<Object, Object>((Class)actualArgs[0]);
            }
            return TypeUtil.createMap(rawType);
        }
        Class clazz = (Class)type;
        if (clazz.isInterface()) {
            throw new CommonRuntimeException("unsupport type " + type);
        }
        if ("java.util.Collections$UnmodifiableMap".equals(clazz.getName())) {
            return new HashMap<Object, Object>();
        }
        try {
            return (Map)clazz.newInstance();
        }
        catch (Exception e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static Pair<Type, Type> getMapKeyValueType(Type mapType) {
        if (mapType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)mapType;
            Type keyType = parameterizedType.getActualTypeArguments()[0];
            Object valueType = null;
            valueType = mapType.getClass().getName().equals("org.springframework.util.LinkedMultiValueMap") ? List.class : parameterizedType.getActualTypeArguments()[1];
            return Pair.of(keyType, valueType);
        }
        Class<Object> objectType = Object.class;
        return Pair.of(objectType, objectType);
    }

    public static Collection createCollection(Type type, int size) {
        Collection list;
        Class rawClass = TypeUtil.getRawClass(type);
        if (rawClass == AbstractCollection.class || rawClass == Collection.class) {
            list = new ArrayList(size);
        } else if (rawClass.isAssignableFrom(HashSet.class)) {
            list = new HashSet(size);
        } else if (rawClass.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet(size);
        } else if (rawClass.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet();
        } else if (rawClass.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList(size);
        } else if (rawClass.isAssignableFrom(EnumSet.class)) {
            Class itemType = TypeUtil.getGenericType(type);
            list = EnumSet.noneOf(itemType);
        } else if (rawClass.isAssignableFrom(Queue.class)) {
            list = new LinkedList();
        } else {
            try {
                list = (Collection)rawClass.newInstance();
            }
            catch (Exception e) {
                throw new CommonRuntimeException(e);
            }
        }
        return list;
    }

    private static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtil.getRawClass(((ParameterizedType)type).getRawType());
        }
        throw new UnsupportedOperationException();
    }

    public static Class getGenericType(Type type) {
        Object itemType = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : Object.class;
        return itemType;
    }

    public static Type getCollectionItemType(Type collectionType) {
        if (collectionType instanceof ParameterizedType) {
            return TypeUtil.getCollectionItemType((ParameterizedType)collectionType);
        }
        if (collectionType instanceof Class) {
            return TypeUtil.getCollectionItemType((Class)collectionType);
        }
        return Object.class;
    }

    private static Type getCollectionItemType(Class<?> clazz) {
        return clazz.getName().startsWith("java.") ? Object.class : TypeUtil.getCollectionItemType(TypeUtil.getCollectionSuperType(clazz));
    }

    private static Type getCollectionItemType(ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (rawType == Collection.class) {
            return TypeUtil.getWildcardTypeUpperBounds(actualTypeArguments[0]);
        }
        Class rawClass = (Class)rawType;
        Map<TypeVariable, Type> actualTypeMap = TypeUtil.createActualTypeMap(rawClass.getTypeParameters(), actualTypeArguments);
        Type superType = TypeUtil.getCollectionSuperType(rawClass);
        if (superType instanceof ParameterizedType) {
            Class<?> superClass = TypeUtil.getRawClass(superType);
            Type[] superClassTypeParameters = ((ParameterizedType)superType).getActualTypeArguments();
            return superClassTypeParameters.length > 0 ? TypeUtil.getCollectionItemType(TypeUtil.makeParameterizedType(superClass, superClassTypeParameters, actualTypeMap)) : TypeUtil.getCollectionItemType(superClass);
        }
        return TypeUtil.getCollectionItemType((Class)superType);
    }

    private static Type getWildcardTypeUpperBounds(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = wildcardType.getUpperBounds();
            return upperBounds.length > 0 ? upperBounds[0] : Object.class;
        }
        return type;
    }

    private static Map<TypeVariable, Type> createActualTypeMap(TypeVariable[] typeParameters, Type[] actualTypeArguments) {
        int length = typeParameters.length;
        HashMap<TypeVariable, Type> actualTypeMap = new HashMap<TypeVariable, Type>(length);
        for (int i = 0; i < length; ++i) {
            actualTypeMap.put(typeParameters[i], actualTypeArguments[i]);
        }
        return actualTypeMap;
    }

    private static Type getCollectionSuperType(Class<?> clazz) {
        Type assignable = null;
        for (Type type : clazz.getGenericInterfaces()) {
            Class<?> rawClass = TypeUtil.getRawClass(type);
            if (rawClass == Collection.class) {
                return type;
            }
            if (!Collection.class.isAssignableFrom(rawClass)) continue;
            assignable = type;
        }
        return assignable == null ? clazz.getGenericSuperclass() : assignable;
    }

    private static ParameterizedType makeParameterizedType(Class<?> rawClass, Type[] typeParameters, Map<TypeVariable, Type> actualTypeMap) {
        int length = typeParameters.length;
        Type[] actualTypeArguments = new Type[length];
        for (int i = 0; i < length; ++i) {
            actualTypeArguments[i] = TypeUtil.getActualType(typeParameters[i], actualTypeMap);
        }
        return new ParameterizedTypeImpl(actualTypeArguments, null, rawClass);
    }

    private static Type getActualType(Type typeParameter, Map<TypeVariable, Type> actualTypeMap) {
        if (typeParameter instanceof TypeVariable) {
            return actualTypeMap.get(typeParameter);
        }
        if (typeParameter instanceof ParameterizedType) {
            return TypeUtil.makeParameterizedType(TypeUtil.getRawClass(typeParameter), ((ParameterizedType)typeParameter).getActualTypeArguments(), actualTypeMap);
        }
        if (typeParameter instanceof GenericArrayType) {
            return new GenericArrayTypeImpl(TypeUtil.getActualType(((GenericArrayType)typeParameter).getGenericComponentType(), actualTypeMap));
        }
        return typeParameter;
    }
}

