/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.util;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class DateUtil {
    public static final String PURE_DATE_FORMAT = "yyyyMMdd";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String PURE_TIME_FORMAT = "HHmmss";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String TIMESTAMP_FORMAT_17 = "yyyyMMddHHmmssSSS";
    public static final String TIMESTAMP_FORMAT_15 = "yyMMddHHmmssSSS";

    private DateUtil() {
    }

    public static String getDateFormat(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static Date getFormatDate(String dateStr, String format) {
        try {
            return new SimpleDateFormat(format).parse(dateStr);
        }
        catch (ParseException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static String getCurrentDateStr() {
        Date now = new Date();
        return new SimpleDateFormat(DATE_FORMAT).format(now);
    }

    public static String getCurrentTimeStampStr() {
        Date now = new Date();
        return new SimpleDateFormat(TIMESTAMP_FORMAT_17).format(now);
    }

    public static String getCurrentDateTimeStr() {
        Date now = new Date();
        return new SimpleDateFormat(DATE_TIME_FORMAT).format(now);
    }

    public static long convertMsToNs(long ms) {
        return TimeUnit.NANOSECONDS.convert(ms > 0L ? ms : 0L, TimeUnit.MILLISECONDS);
    }

    public static Date now() {
        return new Date();
    }

    public static long costTimeInMills(Date start, Date end) {
        return end.getTime() - start.getTime();
    }
}

