/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.util;

import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.support.handler.IMapEntryHandler;
import com.github.houbb.heaven.support.handler.IMapHandler;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MapUtil {
    private MapUtil() {
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || 0 == map.size();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !MapUtil.isEmpty(map);
    }

    public static <K, V> Map<K, V> toMap(Collection<V> values, IHandler<? super V, K> keyFunction) {
        if (ObjectUtil.isNull(values)) {
            return Collections.emptyMap();
        }
        HashMap<K, V> map = new HashMap<K, V>(values.size());
        for (V value : values) {
            K key = keyFunction.handle(value);
            map.put(key, value);
        }
        return map;
    }

    public static <K, V, O> Map<K, V> toMap(Collection<O> values, IMapHandler<K, V, O> mapHandler) {
        if (ObjectUtil.isNull(values)) {
            return Collections.emptyMap();
        }
        HashMap<K, V> map = new HashMap<K, V>(values.size());
        for (O line : values) {
            K key = mapHandler.getKey(line);
            V value = mapHandler.getValue(line);
            map.put(key, value);
        }
        return map;
    }

    public static <K, V, T> List<T> toList(Map<K, V> map, IMapEntryHandler<K, V, T> entryHandler) {
        if (MapUtil.isEmpty(map)) {
            return Collections.emptyList();
        }
        List<T> resultList = Guavas.newArrayList(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            T result = entryHandler.handler(entry);
            resultList.add(result);
        }
        return resultList;
    }

    public static <V> Map<Integer, V> toIndexMap(Collection<V> values) {
        if (ObjectUtil.isNull(values)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, V> map = new HashMap<Integer, V>(values.size());
        for (V v : values) {
            map.put(map.size(), v);
        }
        return map;
    }

    public static String getMapValue(Map<String, String> map, String key) {
        if (MapUtil.isEmpty(map)) {
            return key;
        }
        String value = map.get(key);
        if (StringUtil.isEmpty(value)) {
            return key;
        }
        return value;
    }
}

