/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.io;

import com.github.houbb.heaven.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    public static void extractWar(String warFilePath, String destinationDirectory) {
        try {
            File destinationDir = new File(destinationDirectory);
            if (!destinationDir.exists()) {
                destinationDir.mkdirs();
            }
            try (ZipInputStream zipInputStream = new ZipInputStream(Files.newInputStream(Paths.get(warFilePath, new String[0]), new OpenOption[0]));){
                ZipEntry entry = zipInputStream.getNextEntry();
                while (entry != null) {
                    String filePath = destinationDirectory + File.separator + entry.getName();
                    if (!entry.isDirectory()) {
                        ZipUtil.extractFile(zipInputStream, filePath);
                    } else {
                        File dir = new File(filePath);
                        dir.mkdir();
                    }
                    zipInputStream.closeEntry();
                    entry = zipInputStream.getNextEntry();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void extractFile(ZipInputStream zipInputStream, String filePath) {
        try {
            FileUtil.createFile(filePath);
            try (FileOutputStream fos = new FileOutputStream(filePath);){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = zipInputStream.read(buffer)) > 0) {
                    fos.write(buffer, 0, length);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

