/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang.reflect;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public final class PropertyDescriptorUtil {
    private PropertyDescriptorUtil() {
    }

    public static PropertyDescriptor getPropertyDescriptor(Class beanClass, String propertyName) {
        ArgUtil.notNull(beanClass, "beanClass");
        ArgUtil.notEmpty(propertyName, "propertyName");
        try {
            return new PropertyDescriptor(propertyName, beanClass);
        }
        catch (IntrospectionException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static Method getReadMethod(Class<?> beanClass, String propertyName) {
        PropertyDescriptor propertyDescriptor = PropertyDescriptorUtil.getPropertyDescriptor(beanClass, propertyName);
        return propertyDescriptor.getReadMethod();
    }

    public static Method getWriteMethod(Class beanClass, String propertyName) {
        PropertyDescriptor propertyDescriptor = PropertyDescriptorUtil.getPropertyDescriptor(beanClass, propertyName);
        return propertyDescriptor.getWriteMethod();
    }

    public static Class<?> getPropertyType(Class beanClass, String propertyName) {
        PropertyDescriptor propertyDescriptor = PropertyDescriptorUtil.getPropertyDescriptor(beanClass, propertyName);
        return propertyDescriptor.getPropertyType();
    }

    public static List<PropertyDescriptor> getAllPropertyDescriptorList(final Class beanClass) {
        ArgUtil.notNull(beanClass, "beanClass");
        List<Field> fieldList = ClassUtil.getAllFieldList(beanClass);
        return CollectionUtil.toList(fieldList, new IHandler<Field, PropertyDescriptor>(){

            @Override
            public PropertyDescriptor handle(Field field) {
                String fieldName = field.getName();
                return PropertyDescriptorUtil.getPropertyDescriptor(beanClass, fieldName);
            }
        });
    }

    public static boolean setPropertyValue(Object bean, PropertyDescriptor descriptor, Object value) {
        try {
            Method setMethod = descriptor.getWriteMethod();
            if (setMethod == null) {
                return false;
            }
            setMethod.invoke(bean, value);
            return true;
        }
        catch (Exception e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static boolean setPropertyValue(Object bean, String descriptorName, Object value) {
        PropertyDescriptor propertyDescriptor = PropertyDescriptorUtil.getPropertyDescriptor(bean.getClass(), descriptorName);
        return PropertyDescriptorUtil.setPropertyValue(bean, propertyDescriptor, value);
    }

    public static Object getPropertyValue(Object bean, PropertyDescriptor descriptor) {
        try {
            Method readMethod = descriptor.getReadMethod();
            if (readMethod == null) {
                return null;
            }
            return readMethod.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static Object getPropertyValue(Object bean, String descriptorName) {
        PropertyDescriptor propertyDescriptor = PropertyDescriptorUtil.getPropertyDescriptor(bean.getClass(), descriptorName);
        return PropertyDescriptorUtil.getPropertyValue(bean, propertyDescriptor);
    }
}

