/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.idoc.common.handler.impl.simplify;

import com.github.houbb.idoc.api.model.metadata.DocMethod;
import com.github.houbb.idoc.api.model.metadata.DocMethodParameter;
import com.github.houbb.idoc.api.model.metadata.DocMethodReturn;
import com.github.houbb.idoc.common.handler.IHandler;
import com.github.houbb.idoc.common.handler.impl.simplify.SimplifyDocFieldHandler;
import com.github.houbb.idoc.common.handler.impl.simplify.SimplifyParamFieldHandler;
import com.github.houbb.idoc.common.model.SimplifyDocField;
import com.github.houbb.idoc.common.model.SimplifyDocMethod;
import com.github.houbb.idoc.common.util.CollectionUtil;
import com.github.houbb.idoc.common.util.CommentUtil;
import com.github.houbb.idoc.common.util.ObjectUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SimplifyMethodHandler
implements IHandler<DocMethod, SimplifyDocMethod> {
    @Override
    public SimplifyDocMethod handle(DocMethod docMethod) {
        if (null == docMethod) {
            return null;
        }
        SimplifyDocMethod commonDocMethod = new SimplifyDocMethod();
        commonDocMethod.setComment(docMethod.getComment());
        commonDocMethod.setRemark(docMethod.getRemark());
        commonDocMethod.setName(docMethod.getName());
        String commentFirstLine = CommentUtil.getFirstLine(commonDocMethod.getComment());
        commonDocMethod.setCommentFirstLine(commentFirstLine);
        List<SimplifyDocField> params = this.buildParams(docMethod.getDocMethodParameterList());
        List<SimplifyDocField> returns = this.buildRuturns(docMethod.getDocMethodReturn());
        commonDocMethod.setParams(params);
        commonDocMethod.setReturns(returns);
        commonDocMethod.setParamDetails(this.buildFieldDetails(params));
        commonDocMethod.setReturnDetails(this.buildFieldDetails(returns));
        return commonDocMethod;
    }

    private List<SimplifyDocField> buildParams(List<DocMethodParameter> docMethodParameterList) {
        return CollectionUtil.buildList(docMethodParameterList, new SimplifyParamFieldHandler());
    }

    private List<SimplifyDocField> buildRuturns(DocMethodReturn docMethodReturn) {
        if (ObjectUtil.isNull(docMethodReturn)) {
            return Collections.emptyList();
        }
        List docFieldList = docMethodReturn.getDocFieldList();
        return CollectionUtil.buildList(docFieldList, new SimplifyDocFieldHandler());
    }

    private Map<String, List<SimplifyDocField>> buildFieldDetails(List<SimplifyDocField> fields) {
        if (CollectionUtil.isEmpty(fields)) {
            return null;
        }
        LinkedHashMap<String, List<SimplifyDocField>> map = new LinkedHashMap<String, List<SimplifyDocField>>();
        for (SimplifyDocField docField : fields) {
            String name = docField.getName();
            List<SimplifyDocField> entries = docField.getEntries();
            if (CollectionUtil.isEmpty(entries)) continue;
            map.put(name, entries);
            for (SimplifyDocField entryDocField : entries) {
                List<SimplifyDocField> entryFields = entryDocField.getEntries();
                if (!CollectionUtil.isNotEmpty(entryFields)) continue;
                String entryName = entryDocField.getName();
                map.put(entryName, entryFields);
            }
        }
        return map;
    }
}

