/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.core.report.impl;

import com.github.houbb.junitperf.core.report.Reporter;
import com.github.houbb.junitperf.core.report.impl.ConsoleReporter;
import com.github.houbb.junitperf.model.evaluation.EvaluationContext;
import com.github.houbb.junitperf.support.i18n.I18N;
import com.github.houbb.junitperf.util.FreemarkerUtil;
import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.core.LogFactory;
import com.github.houbb.paradise.common.util.PathUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class HtmlReporter
implements Reporter {
    private static final String DEFAULT_REPORT_PACKAGE = System.getProperty("user.dir") + "/target/junitperf/reports/";
    private static final String REPORT_TEMPLATE = "/templates/";
    private static final Log log = LogFactory.getLog(ConsoleReporter.class);

    @Override
    public void report(Class testClass, Set<EvaluationContext> evaluationContextSet) {
        Path outputPath = Paths.get(DEFAULT_REPORT_PACKAGE + PathUtil.packageToPath((String)testClass.getName()) + ".html", new String[0]);
        try {
            Configuration configuration = FreemarkerUtil.getConfiguration("UTF-8");
            configuration.setClassForTemplateLoading(FreemarkerUtil.class, REPORT_TEMPLATE);
            Template template = configuration.getTemplate("report.ftl");
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            log.info("Rendering report to: " + outputPath);
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("className", testClass.getSimpleName());
            root.put("contextData", evaluationContextSet);
            root.put("milliseconds", (Object)TimeUnit.MILLISECONDS);
            root.put("i18n", I18N.buildI18nVo());
            FreemarkerUtil.createFile(template, outputPath.toString(), root, true);
        }
        catch (Exception e) {
            log.error("HtmlReporter meet ex: {}", (Throwable)e, new Object[]{e});
        }
    }
}

