/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.core.rule;

import com.github.houbb.junitperf.core.annotation.JunitPerfConfig;
import com.github.houbb.junitperf.core.annotation.JunitPerfRequire;
import com.github.houbb.junitperf.core.report.Reporter;
import com.github.houbb.junitperf.core.report.impl.HtmlReporter;
import com.github.houbb.junitperf.core.statistics.StatisticsCalculator;
import com.github.houbb.junitperf.core.statistics.impl.DefaultStatisticsCalculator;
import com.github.houbb.junitperf.model.evaluation.EvaluationContext;
import com.github.houbb.junitperf.support.statements.PerformanceEvaluationStatement;
import com.github.houbb.paradise.common.util.DateUtil;
import com.github.houbb.paradise.common.util.ObjectUtil;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class JunitPerfRule
implements TestRule {
    private final StatisticsCalculator statisticsCalculator;
    private final Set<Reporter> reporterSet;
    private static final ConcurrentHashMap<Class, Set<EvaluationContext>> ACTIVE_CONTEXTS = new ConcurrentHashMap();

    public JunitPerfRule() {
        this((StatisticsCalculator)new DefaultStatisticsCalculator(), new HtmlReporter());
    }

    public JunitPerfRule(Reporter ... reporters) {
        this((StatisticsCalculator)new DefaultStatisticsCalculator(), Sets.newHashSet((Object[])reporters));
    }

    public JunitPerfRule(StatisticsCalculator statisticsCalculator, Reporter ... reporters) {
        this(statisticsCalculator, Sets.newHashSet((Object[])reporters));
    }

    public JunitPerfRule(StatisticsCalculator statisticsCalculator, Set<Reporter> reporterSet) {
        this.statisticsCalculator = statisticsCalculator;
        this.reporterSet = reporterSet;
    }

    public Statement apply(Statement statement, Description description) {
        Statement activeStatement = statement;
        JunitPerfConfig junitPerfConfig = (JunitPerfConfig)description.getAnnotation(JunitPerfConfig.class);
        JunitPerfRequire junitPerfRequire = (JunitPerfRequire)description.getAnnotation(JunitPerfRequire.class);
        if (ObjectUtil.isNotNull((Object)junitPerfConfig).booleanValue()) {
            ACTIVE_CONTEXTS.putIfAbsent(description.getTestClass(), new HashSet());
            EvaluationContext evaluationContext = new EvaluationContext(description.getMethodName(), DateUtil.getSimpleDateStr());
            evaluationContext.loadConfig(junitPerfConfig);
            evaluationContext.loadRequire(junitPerfRequire);
            ACTIVE_CONTEXTS.get(description.getTestClass()).add(evaluationContext);
            activeStatement = new PerformanceEvaluationStatement(evaluationContext, statement, this.statisticsCalculator, this.reporterSet, ACTIVE_CONTEXTS.get(description.getTestClass()), description.getTestClass());
        }
        return activeStatement;
    }
}

