/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.model.evaluation;

import com.github.houbb.junitperf.core.annotation.JunitPerfConfig;
import com.github.houbb.junitperf.core.annotation.JunitPerfRequire;
import com.github.houbb.junitperf.core.statistics.StatisticsCalculator;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationConfig;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationRequire;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationResult;
import com.github.houbb.junitperf.support.builder.EvaluationConfigBuilder;
import com.github.houbb.junitperf.support.builder.EvaluationRequireBuilder;
import com.github.houbb.junitperf.support.builder.EvaluationResultBuilder;
import java.io.Serializable;

public class EvaluationContext
implements Serializable {
    private final String methodName;
    private final String startTime;
    private StatisticsCalculator statisticsCalculator;
    private EvaluationConfig evaluationConfig;
    private EvaluationRequire evaluationRequire;
    private EvaluationResult evaluationResult;

    public EvaluationContext(String methodName, String startTime) {
        this.methodName = methodName;
        this.startTime = startTime;
    }

    public void loadConfig(JunitPerfConfig junitPerfConfig) {
        this.evaluationConfig = new EvaluationConfigBuilder(junitPerfConfig).build();
    }

    public void loadRequire(JunitPerfRequire junitPerfRequire) {
        this.evaluationRequire = new EvaluationRequireBuilder(junitPerfRequire).build();
    }

    public void runValidation() {
        this.evaluationResult = new EvaluationResultBuilder(this.evaluationConfig, this.evaluationRequire, this.statisticsCalculator).build();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public StatisticsCalculator getStatisticsCalculator() {
        return this.statisticsCalculator;
    }

    public void setStatisticsCalculator(StatisticsCalculator statisticsCalculator) {
        this.statisticsCalculator = statisticsCalculator;
    }

    public EvaluationConfig getEvaluationConfig() {
        return this.evaluationConfig;
    }

    public void setEvaluationConfig(EvaluationConfig evaluationConfig) {
        this.evaluationConfig = evaluationConfig;
    }

    public EvaluationRequire getEvaluationRequire() {
        return this.evaluationRequire;
    }

    public void setEvaluationRequire(EvaluationRequire evaluationRequire) {
        this.evaluationRequire = evaluationRequire;
    }

    public EvaluationResult getEvaluationResult() {
        return this.evaluationResult;
    }

    public void setEvaluationResult(EvaluationResult evaluationResult) {
        this.evaluationResult = evaluationResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluationContext that = (EvaluationContext)o;
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        if (this.statisticsCalculator != null ? !this.statisticsCalculator.equals(that.statisticsCalculator) : that.statisticsCalculator != null) {
            return false;
        }
        if (this.evaluationConfig != null ? !this.evaluationConfig.equals(that.evaluationConfig) : that.evaluationConfig != null) {
            return false;
        }
        if (this.evaluationRequire != null ? !this.evaluationRequire.equals(that.evaluationRequire) : that.evaluationRequire != null) {
            return false;
        }
        return this.evaluationResult != null ? this.evaluationResult.equals(that.evaluationResult) : that.evaluationResult == null;
    }

    public int hashCode() {
        int result = this.methodName != null ? this.methodName.hashCode() : 0;
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.statisticsCalculator != null ? this.statisticsCalculator.hashCode() : 0);
        result = 31 * result + (this.evaluationConfig != null ? this.evaluationConfig.hashCode() : 0);
        result = 31 * result + (this.evaluationRequire != null ? this.evaluationRequire.hashCode() : 0);
        result = 31 * result + (this.evaluationResult != null ? this.evaluationResult.hashCode() : 0);
        return result;
    }
}

