/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.support.statements;

import com.github.houbb.junitperf.core.report.Reporter;
import com.github.houbb.junitperf.core.statistics.StatisticsCalculator;
import com.github.houbb.junitperf.model.evaluation.EvaluationContext;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationConfig;
import com.github.houbb.junitperf.support.task.PerformanceEvaluationTask;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import org.junit.runners.model.Statement;

public class PerformanceEvaluationStatement
extends Statement {
    private static final String THREAD_NAME_PATTERN = "performance-evaluation-thread-%d";
    private static final ThreadFactory FACTORY = new ThreadFactoryBuilder().setNameFormat("performance-evaluation-thread-%d").build();
    private final EvaluationContext evaluationContext;
    private final Statement statement;
    private final StatisticsCalculator statisticsCalculator;
    private final Set<Reporter> reporterSet;
    private final Set<EvaluationContext> evaluationContextSet;
    private final Class testClass;

    public PerformanceEvaluationStatement(EvaluationContext evaluationContext, Statement statement, StatisticsCalculator statisticsCalculator, Set<Reporter> reporterSet, Set<EvaluationContext> evaluationContextSet, Class testClass) {
        this.evaluationContext = evaluationContext;
        this.statement = statement;
        this.statisticsCalculator = statisticsCalculator;
        this.reporterSet = reporterSet;
        this.evaluationContextSet = evaluationContextSet;
        this.testClass = testClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        LinkedList<PerformanceEvaluationTask> taskList = new LinkedList<PerformanceEvaluationTask>();
        try {
            EvaluationConfig evaluationConfig = this.evaluationContext.getEvaluationConfig();
            for (int i = 0; i < evaluationConfig.getConfigThreads(); ++i) {
                PerformanceEvaluationTask task = new PerformanceEvaluationTask(evaluationConfig.getConfigWarmUp(), this.statement, this.statisticsCalculator);
                Thread t = FACTORY.newThread(task);
                taskList.add(task);
                t.start();
            }
            Thread.sleep(evaluationConfig.getConfigDuration());
        }
        finally {
            for (PerformanceEvaluationTask task : taskList) {
                task.setContinue(false);
            }
        }
        this.evaluationContext.setStatisticsCalculator(this.statisticsCalculator);
        this.evaluationContext.runValidation();
        this.generateReportor();
    }

    private synchronized void generateReportor() {
        for (Reporter reporter : this.reporterSet) {
            reporter.report(this.testClass, this.evaluationContextSet);
        }
    }
}

